/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class LootItemFunctionSetAttribute
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionSetAttribute> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionSetAttribute.commonFields(var02).and((App)ExtraCodecs.nonEmptyList(b.CODEC.listOf()).fieldOf("modifiers").forGetter(var0 -> var0.modifiers)).apply((Applicative)var02, LootItemFunctionSetAttribute::new));
    private final List<b> modifiers;

    LootItemFunctionSetAttribute(List<LootItemCondition> var0, List<b> var1) {
        super(var0);
        this.modifiers = List.copyOf(var1);
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_ATTRIBUTES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)this.modifiers.stream().flatMap(var0 -> var0.amount.getReferencedContextParams().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        RandomSource var2 = var1.getRandom();
        for (b var4 : this.modifiers) {
            UUID var5 = var4.id.orElseGet(UUID::randomUUID);
            EnumItemSlot var6 = SystemUtils.getRandom(var4.slots, var2);
            var0.addAttributeModifier(var4.attribute.value(), new AttributeModifier(var5, var4.name, var4.amount.getFloat(var1), var4.operation), var6);
        }
        return var0;
    }

    public static c modifier(String var0, Holder<AttributeBase> var1, AttributeModifier.Operation var2, NumberProvider var3) {
        return new c(var0, var1, var2, var3);
    }

    public static a setAttributes() {
        return new a();
    }

    static final class b
    extends Record {
        final String name;
        final Holder<AttributeBase> attribute;
        final AttributeModifier.Operation operation;
        final NumberProvider amount;
        final List<EnumItemSlot> slots;
        final Optional<UUID> id;
        private static final Codec<List<EnumItemSlot>> SLOTS_CODEC = ExtraCodecs.nonEmptyList(Codec.either(EnumItemSlot.CODEC, (Codec)EnumItemSlot.CODEC.listOf()).xmap(var0 -> (List)var0.map(List::of, Function.identity()), var0 -> var0.size() == 1 ? Either.left((Object)((EnumItemSlot)var0.get(0))) : Either.right((Object)var0)));
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.STRING.fieldOf("name").forGetter(b::name), (App)BuiltInRegistries.ATTRIBUTE.holderByNameCodec().fieldOf("attribute").forGetter(b::attribute), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(b::operation), (App)NumberProviders.CODEC.fieldOf("amount").forGetter(b::amount), (App)SLOTS_CODEC.fieldOf("slot").forGetter(b::slots), (App)ExtraCodecs.strictOptionalField(UUIDUtil.STRING_CODEC, "id").forGetter(b::id)).apply((Applicative)var0, b::new));

        b(String var0, Holder<AttributeBase> var1, AttributeModifier.Operation var2, NumberProvider var3, List<EnumItemSlot> var4, Optional<UUID> var5) {
            this.name = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
            this.slots = var4;
            this.id = var5;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "name;attribute;operation;amount;slots;id", "name", "attribute", "operation", "amount", "slots", "id"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "name;attribute;operation;amount;slots;id", "name", "attribute", "operation", "amount", "slots", "id"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "name;attribute;operation;amount;slots;id", "name", "attribute", "operation", "amount", "slots", "id"}, this, var0);
        }

        public String name() {
            return this.name;
        }

        public Holder<AttributeBase> attribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation operation() {
            return this.operation;
        }

        public NumberProvider amount() {
            return this.amount;
        }

        public List<EnumItemSlot> slots() {
            return this.slots;
        }

        public Optional<UUID> id() {
            return this.id;
        }
    }

    public static class c {
        private final String name;
        private final Holder<AttributeBase> attribute;
        private final AttributeModifier.Operation operation;
        private final NumberProvider amount;
        private Optional<UUID> id = Optional.empty();
        private final Set<EnumItemSlot> slots = EnumSet.noneOf(EnumItemSlot.class);

        public c(String var0, Holder<AttributeBase> var1, AttributeModifier.Operation var2, NumberProvider var3) {
            this.name = var0;
            this.attribute = var1;
            this.operation = var2;
            this.amount = var3;
        }

        public c forSlot(EnumItemSlot var0) {
            this.slots.add(var0);
            return this;
        }

        public c withUuid(UUID var0) {
            this.id = Optional.of(var0);
            return this;
        }

        public b build() {
            return new b(this.name, this.attribute, this.operation, this.amount, List.copyOf(this.slots), this.id);
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<b> modifiers = Lists.newArrayList();

        @Override
        protected a getThis() {
            return this;
        }

        public a withModifier(c var0) {
            this.modifiers.add(var0.build());
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetAttribute(this.getConditions(), this.modifiers);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

