/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.slf4j.Logger;

public class FunctionReference
extends LootItemFunctionConditional {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<FunctionReference> CODEC = RecordCodecBuilder.create(var02 -> FunctionReference.commonFields(var02).and((App)MinecraftKey.CODEC.fieldOf("name").forGetter(var0 -> var0.name)).apply((Applicative)var02, FunctionReference::new));
    private final MinecraftKey name;

    private FunctionReference(List<LootItemCondition> var0, MinecraftKey var1) {
        super(var0);
        this.name = var1;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.REFERENCE;
    }

    @Override
    public void validate(LootCollector var0) {
        LootDataId<LootItemFunction> var1 = new LootDataId<LootItemFunction>(LootDataType.MODIFIER, this.name);
        if (var0.hasVisitedElement(var1)) {
            var0.reportProblem("Function " + this.name + " is recursively called");
            return;
        }
        super.validate(var0);
        var0.resolver().getElementOptional(var1).ifPresentOrElse(var2 -> var2.validate(var0.enterElement(".{" + this.name + "}", var1)), () -> var0.reportProblem("Unknown function table called " + this.name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        LootItemFunction var2 = var1.getResolver().getElement(LootDataType.MODIFIER, this.name);
        if (var2 == null) {
            LOGGER.warn("Unknown function: {}", (Object)this.name);
            return var0;
        }
        LootTableInfo.c<LootItemFunction> var3 = LootTableInfo.createVisitedEntry(var2);
        if (var1.pushVisitedElement(var3)) {
            try {
                ItemStack itemStack = (ItemStack)var2.apply(var0, var1);
                return itemStack;
            }
            finally {
                var1.popVisitedElement(var3);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return var0;
    }

    public static LootItemFunctionConditional.a<?> functionReference(MinecraftKey var0) {
        return FunctionReference.simpleBuilder(var1 -> new FunctionReference((List<LootItemCondition>)var1, var0));
    }
}

