/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.serialization.Codec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryAlternatives;
import net.minecraft.world.level.storage.loot.entries.LootEntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootEntrySequence;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootSelectorDynamic;
import net.minecraft.world.level.storage.loot.entries.LootSelectorEmpty;
import net.minecraft.world.level.storage.loot.entries.LootSelectorLootTable;
import net.minecraft.world.level.storage.loot.entries.LootSelectorTag;

public class LootEntries {
    public static final Codec<LootEntryAbstract> CODEC = BuiltInRegistries.LOOT_POOL_ENTRY_TYPE.byNameCodec().dispatch(LootEntryAbstract::getType, LootEntryType::codec);
    public static final LootEntryType EMPTY = LootEntries.register("empty", LootSelectorEmpty.CODEC);
    public static final LootEntryType ITEM = LootEntries.register("item", LootItem.CODEC);
    public static final LootEntryType REFERENCE = LootEntries.register("loot_table", LootSelectorLootTable.CODEC);
    public static final LootEntryType DYNAMIC = LootEntries.register("dynamic", LootSelectorDynamic.CODEC);
    public static final LootEntryType TAG = LootEntries.register("tag", LootSelectorTag.CODEC);
    public static final LootEntryType ALTERNATIVES = LootEntries.register("alternatives", LootEntryAlternatives.CODEC);
    public static final LootEntryType SEQUENCE = LootEntries.register("sequence", LootEntrySequence.CODEC);
    public static final LootEntryType GROUP = LootEntries.register("group", LootEntryGroup.CODEC);

    private static LootEntryType register(String var0, Codec<? extends LootEntryAbstract> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_POOL_ENTRY_TYPE, new MinecraftKey(var0), new LootEntryType(var1));
    }
}

