/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public class LootDataType<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final LootDataType<LootItemCondition> PREDICATE = new LootDataType<LootItemCondition>(LootItemConditions.CODEC, "predicates", LootDataType.createSimpleValidator());
    public static final LootDataType<LootItemFunction> MODIFIER = new LootDataType<LootItemFunction>(LootItemFunctions.CODEC, "item_modifiers", LootDataType.createSimpleValidator());
    public static final LootDataType<LootTable> TABLE = new LootDataType<LootTable>(LootTable.CODEC, "loot_tables", LootDataType.createLootTableValidator());
    private final Codec<T> codec;
    private final String directory;
    private final a<T> validator;

    private LootDataType(Codec<T> var0, String var1, a<T> var2) {
        this.codec = var0;
        this.directory = var1;
        this.validator = var2;
    }

    public String directory() {
        return this.directory;
    }

    public void runValidation(LootCollector var0, LootDataId<T> var1, T var2) {
        this.validator.run(var0, var1, var2);
    }

    public Optional<T> deserialize(MinecraftKey var0, JsonElement var12) {
        DataResult var2 = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)var12);
        var2.error().ifPresent(var1 -> LOGGER.error("Couldn't parse element {}:{} - {}", new Object[]{this.directory, var0, var1.message()}));
        return var2.result();
    }

    public static Stream<LootDataType<?>> values() {
        return Stream.of(PREDICATE, MODIFIER, TABLE);
    }

    private static <T extends LootItemUser> a<T> createSimpleValidator() {
        return (var0, var1, var2) -> var2.validate(var0.enterElement("{" + var1.type().directory + ":" + var1.location() + "}", var1));
    }

    private static a<LootTable> createLootTableValidator() {
        return (var0, var1, var2) -> var2.validate(var0.setParams(var2.getParamSet()).enterElement("{" + var1.type().directory + ":" + var1.location() + "}", var1));
    }

    @FunctionalInterface
    public static interface a<T> {
        public void run(LootCollector var1, LootDataId<T> var2, T var3);
    }
}

