/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;

public class DefinedStructureProcessorBlackstoneReplace
extends DefinedStructureProcessor {
    public static final Codec<DefinedStructureProcessorBlackstoneReplace> CODEC = Codec.unit(() -> INSTANCE);
    public static final DefinedStructureProcessorBlackstoneReplace INSTANCE = new DefinedStructureProcessorBlackstoneReplace();
    private final Map<Block, Block> replacements = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(Blocks.COBBLESTONE, Blocks.BLACKSTONE);
        var0.put(Blocks.MOSSY_COBBLESTONE, Blocks.BLACKSTONE);
        var0.put(Blocks.STONE, Blocks.POLISHED_BLACKSTONE);
        var0.put(Blocks.STONE_BRICKS, Blocks.POLISHED_BLACKSTONE_BRICKS);
        var0.put(Blocks.MOSSY_STONE_BRICKS, Blocks.POLISHED_BLACKSTONE_BRICKS);
        var0.put(Blocks.COBBLESTONE_STAIRS, Blocks.BLACKSTONE_STAIRS);
        var0.put(Blocks.MOSSY_COBBLESTONE_STAIRS, Blocks.BLACKSTONE_STAIRS);
        var0.put(Blocks.STONE_STAIRS, Blocks.POLISHED_BLACKSTONE_STAIRS);
        var0.put(Blocks.STONE_BRICK_STAIRS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS);
        var0.put(Blocks.MOSSY_STONE_BRICK_STAIRS, Blocks.POLISHED_BLACKSTONE_BRICK_STAIRS);
        var0.put(Blocks.COBBLESTONE_SLAB, Blocks.BLACKSTONE_SLAB);
        var0.put(Blocks.MOSSY_COBBLESTONE_SLAB, Blocks.BLACKSTONE_SLAB);
        var0.put(Blocks.SMOOTH_STONE_SLAB, Blocks.POLISHED_BLACKSTONE_SLAB);
        var0.put(Blocks.STONE_SLAB, Blocks.POLISHED_BLACKSTONE_SLAB);
        var0.put(Blocks.STONE_BRICK_SLAB, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB);
        var0.put(Blocks.MOSSY_STONE_BRICK_SLAB, Blocks.POLISHED_BLACKSTONE_BRICK_SLAB);
        var0.put(Blocks.STONE_BRICK_WALL, Blocks.POLISHED_BLACKSTONE_BRICK_WALL);
        var0.put(Blocks.MOSSY_STONE_BRICK_WALL, Blocks.POLISHED_BLACKSTONE_BRICK_WALL);
        var0.put(Blocks.COBBLESTONE_WALL, Blocks.BLACKSTONE_WALL);
        var0.put(Blocks.MOSSY_COBBLESTONE_WALL, Blocks.BLACKSTONE_WALL);
        var0.put(Blocks.CHISELED_STONE_BRICKS, Blocks.CHISELED_POLISHED_BLACKSTONE);
        var0.put(Blocks.CRACKED_STONE_BRICKS, Blocks.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        var0.put(Blocks.IRON_BARS, Blocks.CHAIN);
    });

    private DefinedStructureProcessorBlackstoneReplace() {
    }

    @Override
    public DefinedStructure.BlockInfo processBlock(IWorldReader var0, BlockPosition var1, BlockPosition var2, DefinedStructure.BlockInfo var3, DefinedStructure.BlockInfo var4, DefinedStructureInfo var5) {
        Block var6 = this.replacements.get(var4.state().getBlock());
        if (var6 == null) {
            return var4;
        }
        IBlockData var7 = var4.state();
        IBlockData var8 = var6.defaultBlockState();
        if (var7.hasProperty(BlockStairs.FACING)) {
            var8 = (IBlockData)var8.setValue(BlockStairs.FACING, var7.getValue(BlockStairs.FACING));
        }
        if (var7.hasProperty(BlockStairs.HALF)) {
            var8 = (IBlockData)var8.setValue(BlockStairs.HALF, var7.getValue(BlockStairs.HALF));
        }
        if (var7.hasProperty(BlockStepAbstract.TYPE)) {
            var8 = (IBlockData)var8.setValue(BlockStepAbstract.TYPE, var7.getValue(BlockStepAbstract.TYPE));
        }
        return new DefinedStructure.BlockInfo(var4.pos(), var8, var4.nbt());
    }

    @Override
    protected DefinedStructureStructureProcessorType<?> getType() {
        return DefinedStructureStructureProcessorType.BLACKSTONE_REPLACE;
    }
}

