/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;

public class DefinedStructure {
    public static final String PALETTE_TAG = "palette";
    public static final String PALETTE_LIST_TAG = "palettes";
    public static final String ENTITIES_TAG = "entities";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BLOCK_TAG_POS = "pos";
    public static final String BLOCK_TAG_STATE = "state";
    public static final String BLOCK_TAG_NBT = "nbt";
    public static final String ENTITY_TAG_POS = "pos";
    public static final String ENTITY_TAG_BLOCKPOS = "blockPos";
    public static final String ENTITY_TAG_NBT = "nbt";
    public static final String SIZE_TAG = "size";
    public final List<a> palettes = Lists.newArrayList();
    public final List<EntityInfo> entityInfoList = Lists.newArrayList();
    private BaseBlockPosition size = BaseBlockPosition.ZERO;
    private String author = "?";

    public BaseBlockPosition getSize() {
        return this.size;
    }

    public void setAuthor(String var0) {
        this.author = var0;
    }

    public String getAuthor() {
        return this.author;
    }

    public void fillFromWorld(World var0, BlockPosition var1, BaseBlockPosition var2, boolean var3, @Nullable Block var4) {
        if (var2.getX() < 1 || var2.getY() < 1 || var2.getZ() < 1) {
            return;
        }
        BlockPosition var5 = var1.offset(var2).offset(-1, -1, -1);
        ArrayList var6 = Lists.newArrayList();
        ArrayList var7 = Lists.newArrayList();
        ArrayList var8 = Lists.newArrayList();
        BlockPosition var9 = new BlockPosition(Math.min(var1.getX(), var5.getX()), Math.min(var1.getY(), var5.getY()), Math.min(var1.getZ(), var5.getZ()));
        BlockPosition var10 = new BlockPosition(Math.max(var1.getX(), var5.getX()), Math.max(var1.getY(), var5.getY()), Math.max(var1.getZ(), var5.getZ()));
        this.size = var2;
        for (BlockPosition var12 : BlockPosition.betweenClosed(var9, var10)) {
            BlockPosition var13 = var12.subtract(var9);
            IBlockData var14 = var0.getBlockState(var12);
            if (var4 != null && var14.is(var4)) continue;
            TileEntity var15 = var0.getBlockEntity(var12);
            BlockInfo var16 = var15 != null ? new BlockInfo(var13, var14, var15.saveWithId()) : new BlockInfo(var13, var14, null);
            DefinedStructure.addToLists(var16, var6, var7, var8);
        }
        List<BlockInfo> var11 = DefinedStructure.buildInfoList(var6, var7, var8);
        this.palettes.clear();
        this.palettes.add(new a(var11));
        if (var3) {
            this.fillEntityList(var0, var9, var10);
        } else {
            this.entityInfoList.clear();
        }
    }

    private static void addToLists(BlockInfo var0, List<BlockInfo> var1, List<BlockInfo> var2, List<BlockInfo> var3) {
        if (var0.nbt != null) {
            var2.add(var0);
        } else if (!var0.state.getBlock().hasDynamicShape() && var0.state.isCollisionShapeFullBlock(BlockAccessAir.INSTANCE, BlockPosition.ZERO)) {
            var1.add(var0);
        } else {
            var3.add(var0);
        }
    }

    private static List<BlockInfo> buildInfoList(List<BlockInfo> var02, List<BlockInfo> var1, List<BlockInfo> var2) {
        Comparator<BlockInfo> var3 = Comparator.comparingInt(var0 -> var0.pos.getY()).thenComparingInt(var0 -> var0.pos.getX()).thenComparingInt(var0 -> var0.pos.getZ());
        var02.sort(var3);
        var2.sort(var3);
        var1.sort(var3);
        ArrayList var4 = Lists.newArrayList();
        var4.addAll(var02);
        var4.addAll(var2);
        var4.addAll(var1);
        return var4;
    }

    private void fillEntityList(World var02, BlockPosition var1, BlockPosition var2) {
        List<Entity> var3 = var02.getEntitiesOfClass(Entity.class, AxisAlignedBB.encapsulatingFullBlocks(var1, var2), var0 -> !(var0 instanceof EntityHuman));
        this.entityInfoList.clear();
        for (Entity var5 : var3) {
            Vec3D var6 = new Vec3D(var5.getX() - (double)var1.getX(), var5.getY() - (double)var1.getY(), var5.getZ() - (double)var1.getZ());
            NBTTagCompound var7 = new NBTTagCompound();
            var5.save(var7);
            BlockPosition var8 = var5 instanceof EntityPainting ? ((EntityPainting)var5).getPos().subtract(var1) : BlockPosition.containing(var6);
            this.entityInfoList.add(new EntityInfo(var6, var8, var7.copy()));
        }
    }

    public List<BlockInfo> filterBlocks(BlockPosition var0, DefinedStructureInfo var1, Block var2) {
        return this.filterBlocks(var0, var1, var2, true);
    }

    public ObjectArrayList<BlockInfo> filterBlocks(BlockPosition var0, DefinedStructureInfo var1, Block var2, boolean var3) {
        ObjectArrayList var4 = new ObjectArrayList();
        StructureBoundingBox var5 = var1.getBoundingBox();
        if (this.palettes.isEmpty()) {
            return var4;
        }
        for (BlockInfo var7 : var1.getRandomPalette(this.palettes, var0).blocks(var2)) {
            BlockPosition var8;
            BlockPosition blockPosition = var8 = var3 ? DefinedStructure.calculateRelativePosition(var1, var7.pos).offset(var0) : var7.pos;
            if (var5 != null && !var5.isInside(var8)) continue;
            var4.add((Object)new BlockInfo(var8, var7.state.rotate(var1.getRotation()), var7.nbt));
        }
        return var4;
    }

    public BlockPosition calculateConnectedPosition(DefinedStructureInfo var0, BlockPosition var1, DefinedStructureInfo var2, BlockPosition var3) {
        BlockPosition var4 = DefinedStructure.calculateRelativePosition(var0, var1);
        BlockPosition var5 = DefinedStructure.calculateRelativePosition(var2, var3);
        return var4.subtract(var5);
    }

    public static BlockPosition calculateRelativePosition(DefinedStructureInfo var0, BlockPosition var1) {
        return DefinedStructure.transform(var1, var0.getMirror(), var0.getRotation(), var0.getRotationPivot());
    }

    public boolean placeInWorld(WorldAccess var0, BlockPosition var1, BlockPosition var2, DefinedStructureInfo var3, RandomSource var4, int var5) {
        Fluid var25;
        Object var24;
        IBlockDataHolder var22;
        Object var21;
        Object var20;
        if (this.palettes.isEmpty()) {
            return false;
        }
        List<BlockInfo> var6 = var3.getRandomPalette(this.palettes, var1).blocks();
        if (var6.isEmpty() && (var3.isIgnoreEntities() || this.entityInfoList.isEmpty()) || this.size.getX() < 1 || this.size.getY() < 1 || this.size.getZ() < 1) {
            return false;
        }
        StructureBoundingBox var7 = var3.getBoundingBox();
        ArrayList var8 = Lists.newArrayListWithCapacity((int)(var3.shouldKeepLiquids() ? var6.size() : 0));
        ArrayList var9 = Lists.newArrayListWithCapacity((int)(var3.shouldKeepLiquids() ? var6.size() : 0));
        ArrayList var10 = Lists.newArrayListWithCapacity((int)var6.size());
        int var11 = Integer.MAX_VALUE;
        int var12 = Integer.MAX_VALUE;
        int var13 = Integer.MAX_VALUE;
        int var14 = Integer.MIN_VALUE;
        int var15 = Integer.MIN_VALUE;
        int var16 = Integer.MIN_VALUE;
        List<BlockInfo> var17 = DefinedStructure.processBlockInfos(var0, var1, var2, var3, var6);
        for (BlockInfo blockInfo : var17) {
            TileEntity var23;
            var20 = blockInfo.pos;
            if (var7 != null && !var7.isInside((BaseBlockPosition)var20)) continue;
            var21 = var3.shouldKeepLiquids() ? var0.getFluidState((BlockPosition)var20) : null;
            var22 = blockInfo.state.mirror(var3.getMirror()).rotate(var3.getRotation());
            if (blockInfo.nbt != null) {
                var23 = var0.getBlockEntity((BlockPosition)var20);
                Clearable.tryClear(var23);
                var0.setBlock((BlockPosition)var20, Blocks.BARRIER.defaultBlockState(), 20);
            }
            if (!var0.setBlock((BlockPosition)var20, (IBlockData)var22, var5)) continue;
            var11 = Math.min(var11, ((BaseBlockPosition)var20).getX());
            var12 = Math.min(var12, ((BaseBlockPosition)var20).getY());
            var13 = Math.min(var13, ((BaseBlockPosition)var20).getZ());
            var14 = Math.max(var14, ((BaseBlockPosition)var20).getX());
            var15 = Math.max(var15, ((BaseBlockPosition)var20).getY());
            var16 = Math.max(var16, ((BaseBlockPosition)var20).getZ());
            var10.add(Pair.of((Object)var20, (Object)blockInfo.nbt));
            if (blockInfo.nbt != null && (var23 = var0.getBlockEntity((BlockPosition)var20)) != null) {
                if (var23 instanceof RandomizableContainer) {
                    blockInfo.nbt.putLong("LootTableSeed", var4.nextLong());
                }
                var23.load(blockInfo.nbt);
            }
            if (var21 == null) continue;
            if (((BlockBase.BlockData)var22).getFluidState().isSource()) {
                var9.add(var20);
                continue;
            }
            if (!(((BlockBase.BlockData)var22).getBlock() instanceof IFluidContainer)) continue;
            ((IFluidContainer)((Object)((BlockBase.BlockData)var22).getBlock())).placeLiquid(var0, (BlockPosition)var20, (IBlockData)var22, (Fluid)var21);
            if (((Fluid)var21).isSource()) continue;
            var8.add(var20);
        }
        boolean var18 = true;
        EnumDirection[] enumDirectionArray = new EnumDirection[]{EnumDirection.UP, EnumDirection.NORTH, EnumDirection.EAST, EnumDirection.SOUTH, EnumDirection.WEST};
        while (var18 && !var8.isEmpty()) {
            var18 = false;
            var20 = var8.iterator();
            while (var20.hasNext()) {
                IBlockData var23;
                var21 = (BlockPosition)var20.next();
                var22 = var0.getFluidState((BlockPosition)var21);
                for (int var232 = 0; var232 < enumDirectionArray.length && !((Fluid)var22).isSource(); ++var232) {
                    var24 = ((BlockPosition)var21).relative(enumDirectionArray[var232]);
                    var25 = var0.getFluidState((BlockPosition)var24);
                    if (!var25.isSource() || var9.contains(var24)) continue;
                    var22 = var25;
                }
                if (!((Fluid)var22).isSource() || !((var24 = (var23 = var0.getBlockState((BlockPosition)var21)).getBlock()) instanceof IFluidContainer)) continue;
                ((IFluidContainer)var24).placeLiquid(var0, (BlockPosition)var21, var23, (Fluid)var22);
                var18 = true;
                var20.remove();
            }
        }
        if (var11 <= var14) {
            if (!var3.getKnownShape()) {
                var20 = new VoxelShapeBitSet(var14 - var11 + 1, var15 - var12 + 1, var16 - var13 + 1);
                int var212 = var11;
                int var222 = var12;
                int var23 = var13;
                var24 = var10.iterator();
                while (var24.hasNext()) {
                    var25 = (Pair)var24.next();
                    BlockPosition var26 = (BlockPosition)var25.getFirst();
                    ((VoxelShapeDiscrete)var20).fill(var26.getX() - var212, var26.getY() - var222, var26.getZ() - var23);
                }
                DefinedStructure.updateShapeAtEdge(var0, var5, (VoxelShapeDiscrete)var20, var212, var222, var23);
            }
            for (Pair var213 : var10) {
                TileEntity var23;
                BlockPosition var223 = (BlockPosition)var213.getFirst();
                if (!var3.getKnownShape()) {
                    IBlockData var233 = var0.getBlockState(var223);
                    if (var233 != (var24 = Block.updateFromNeighbourShapes(var233, var0, var223))) {
                        var0.setBlock(var223, (IBlockData)var24, var5 & 0xFFFFFFFE | 0x10);
                    }
                    var0.blockUpdated(var223, ((BlockBase.BlockData)var24).getBlock());
                }
                if (var213.getSecond() == null || (var23 = var0.getBlockEntity(var223)) == null) continue;
                var23.setChanged();
            }
        }
        if (!var3.isIgnoreEntities()) {
            this.placeEntities(var0, var1, var3.getMirror(), var3.getRotation(), var3.getRotationPivot(), var7, var3.shouldFinalizeEntities());
        }
        return true;
    }

    public static void updateShapeAtEdge(GeneratorAccess var0, int var1, VoxelShapeDiscrete var2, int var3, int var4, int var52) {
        var2.forAllFaces((var5, var6, var7, var8) -> {
            IBlockData var14;
            IBlockData var12;
            IBlockData var13;
            BlockPosition var9 = new BlockPosition(var3 + var6, var4 + var7, var52 + var8);
            BlockPosition var10 = var9.relative(var5);
            IBlockData var11 = var0.getBlockState(var9);
            if (var11 != (var13 = var11.updateShape(var5, var12 = var0.getBlockState(var10), var0, var9, var10))) {
                var0.setBlock(var9, var13, var1 & 0xFFFFFFFE);
            }
            if (var12 != (var14 = var12.updateShape(var5.getOpposite(), var13, var0, var10, var9))) {
                var0.setBlock(var10, var14, var1 & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> processBlockInfos(WorldAccess var0, BlockPosition var1, BlockPosition var2, DefinedStructureInfo var3, List<BlockInfo> var4) {
        ArrayList<BlockInfo> var5 = new ArrayList<BlockInfo>();
        List<BlockInfo> var6 = new ArrayList<BlockInfo>();
        for (BlockInfo blockInfo : var4) {
            BlockPosition var9 = DefinedStructure.calculateRelativePosition(var3, blockInfo.pos).offset(var1);
            BlockInfo var10 = new BlockInfo(var9, blockInfo.state, blockInfo.nbt != null ? blockInfo.nbt.copy() : null);
            Iterator<DefinedStructureProcessor> var11 = var3.getProcessors().iterator();
            while (var10 != null && var11.hasNext()) {
                var10 = var11.next().processBlock(var0, var1, var2, blockInfo, var10, var3);
            }
            if (var10 == null) continue;
            var6.add(var10);
            var5.add(blockInfo);
        }
        for (DefinedStructureProcessor definedStructureProcessor : var3.getProcessors()) {
            var6 = definedStructureProcessor.finalizeProcessing(var0, var1, var2, var5, var6, var3);
        }
        return var6;
    }

    private void placeEntities(WorldAccess var0, BlockPosition var1, EnumBlockMirror var2, EnumBlockRotation var3, BlockPosition var4, @Nullable StructureBoundingBox var5, boolean var62) {
        for (EntityInfo var8 : this.entityInfoList) {
            BlockPosition var9 = DefinedStructure.transform(var8.blockPos, var2, var3, var4).offset(var1);
            if (var5 != null && !var5.isInside(var9)) continue;
            NBTTagCompound var10 = var8.nbt.copy();
            Vec3D var11 = DefinedStructure.transform(var8.pos, var2, var3, var4);
            Vec3D var12 = var11.add(var1.getX(), var1.getY(), var1.getZ());
            NBTTagList var13 = new NBTTagList();
            var13.add(NBTTagDouble.valueOf(var12.x));
            var13.add(NBTTagDouble.valueOf(var12.y));
            var13.add(NBTTagDouble.valueOf(var12.z));
            var10.put("Pos", var13);
            var10.remove("UUID");
            DefinedStructure.createEntityIgnoreException(var0, var10).ifPresent(var6 -> {
                float var7 = var6.rotate(var3);
                var6.moveTo(var2.x, var2.y, var2.z, var7 += var6.mirror(var2) - var6.getYRot(), var6.getXRot());
                if (var62 && var6 instanceof EntityInsentient) {
                    ((EntityInsentient)var6).finalizeSpawn(var0, var0.getCurrentDifficultyAt(BlockPosition.containing(var12)), EnumMobSpawn.STRUCTURE, null, var10);
                }
                var0.addFreshEntityWithPassengers((Entity)var6);
            });
        }
    }

    private static Optional<Entity> createEntityIgnoreException(WorldAccess var0, NBTTagCompound var1) {
        try {
            return EntityTypes.create(var1, var0.getLevel());
        }
        catch (Exception var2) {
            return Optional.empty();
        }
    }

    public BaseBlockPosition getSize(EnumBlockRotation var0) {
        switch (var0) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new BaseBlockPosition(this.size.getZ(), this.size.getY(), this.size.getX());
            }
        }
        return this.size;
    }

    public static BlockPosition transform(BlockPosition var0, EnumBlockMirror var1, EnumBlockRotation var2, BlockPosition var3) {
        int var4 = var0.getX();
        int var5 = var0.getY();
        int var6 = var0.getZ();
        boolean var7 = true;
        switch (var1) {
            case LEFT_RIGHT: {
                var6 = -var6;
                break;
            }
            case FRONT_BACK: {
                var4 = -var4;
                break;
            }
            default: {
                var7 = false;
            }
        }
        int var8 = var3.getX();
        int var9 = var3.getZ();
        switch (var2) {
            case CLOCKWISE_180: {
                return new BlockPosition(var8 + var8 - var4, var5, var9 + var9 - var6);
            }
            case COUNTERCLOCKWISE_90: {
                return new BlockPosition(var8 - var9 + var6, var5, var8 + var9 - var4);
            }
            case CLOCKWISE_90: {
                return new BlockPosition(var8 + var9 - var6, var5, var9 - var8 + var4);
            }
        }
        return var7 ? new BlockPosition(var4, var5, var6) : var0;
    }

    public static Vec3D transform(Vec3D var0, EnumBlockMirror var1, EnumBlockRotation var2, BlockPosition var3) {
        double var4 = var0.x;
        double var6 = var0.y;
        double var8 = var0.z;
        boolean var10 = true;
        switch (var1) {
            case LEFT_RIGHT: {
                var8 = 1.0 - var8;
                break;
            }
            case FRONT_BACK: {
                var4 = 1.0 - var4;
                break;
            }
            default: {
                var10 = false;
            }
        }
        int var11 = var3.getX();
        int var12 = var3.getZ();
        switch (var2) {
            case CLOCKWISE_180: {
                return new Vec3D((double)(var11 + var11 + 1) - var4, var6, (double)(var12 + var12 + 1) - var8);
            }
            case COUNTERCLOCKWISE_90: {
                return new Vec3D((double)(var11 - var12) + var8, var6, (double)(var11 + var12 + 1) - var4);
            }
            case CLOCKWISE_90: {
                return new Vec3D((double)(var11 + var12 + 1) - var8, var6, (double)(var12 - var11) + var4);
            }
        }
        return var10 ? new Vec3D(var4, var6, var8) : var0;
    }

    public BlockPosition getZeroPositionWithTransform(BlockPosition var0, EnumBlockMirror var1, EnumBlockRotation var2) {
        return DefinedStructure.getZeroPositionWithTransform(var0, var1, var2, this.getSize().getX(), this.getSize().getZ());
    }

    public static BlockPosition getZeroPositionWithTransform(BlockPosition var0, EnumBlockMirror var1, EnumBlockRotation var2, int var3, int var4) {
        int var5 = var1 == EnumBlockMirror.FRONT_BACK ? --var3 : 0;
        int var6 = var1 == EnumBlockMirror.LEFT_RIGHT ? --var4 : 0;
        BlockPosition var7 = var0;
        switch (var2) {
            case NONE: {
                var7 = var0.offset(var5, 0, var6);
                break;
            }
            case CLOCKWISE_90: {
                var7 = var0.offset(var4 - var6, 0, var5);
                break;
            }
            case CLOCKWISE_180: {
                var7 = var0.offset(var3 - var5, 0, var4 - var6);
                break;
            }
            case COUNTERCLOCKWISE_90: {
                var7 = var0.offset(var6, 0, var3 - var5);
            }
        }
        return var7;
    }

    public StructureBoundingBox getBoundingBox(DefinedStructureInfo var0, BlockPosition var1) {
        return this.getBoundingBox(var1, var0.getRotation(), var0.getRotationPivot(), var0.getMirror());
    }

    public StructureBoundingBox getBoundingBox(BlockPosition var0, EnumBlockRotation var1, BlockPosition var2, EnumBlockMirror var3) {
        return DefinedStructure.getBoundingBox(var0, var1, var2, var3, this.size);
    }

    @VisibleForTesting
    protected static StructureBoundingBox getBoundingBox(BlockPosition var0, EnumBlockRotation var1, BlockPosition var2, EnumBlockMirror var3, BaseBlockPosition var4) {
        BaseBlockPosition var5 = var4.offset(-1, -1, -1);
        BlockPosition var6 = DefinedStructure.transform(BlockPosition.ZERO, var3, var1, var2);
        BlockPosition var7 = DefinedStructure.transform(BlockPosition.ZERO.offset(var5), var3, var1, var2);
        return StructureBoundingBox.fromCorners(var6, var7).move(var0);
    }

    /*
     * WARNING - void declaration
     */
    public NBTTagCompound save(NBTTagCompound var0) {
        Object var4;
        AbstractList var1;
        if (this.palettes.isEmpty()) {
            var0.put(BLOCKS_TAG, new NBTTagList());
            var0.put(PALETTE_TAG, new NBTTagList());
        } else {
            Object var10;
            void var4_5;
            var1 = Lists.newArrayList();
            b var2 = new b();
            var1.add(var2);
            boolean bl = true;
            while (var4_5 < this.palettes.size()) {
                var1.add(new b());
                ++var4_5;
            }
            NBTTagList nBTTagList = new NBTTagList();
            var4 = this.palettes.get(0).blocks();
            for (int var5 = 0; var5 < var4.size(); ++var5) {
                BlockInfo var6 = (BlockInfo)var4.get(var5);
                Object var7 = new NBTTagCompound();
                ((NBTTagCompound)var7).put("pos", this.newIntegerList(var6.pos.getX(), var6.pos.getY(), var6.pos.getZ()));
                int var8 = var2.idFor(var6.state);
                ((NBTTagCompound)var7).putInt(BLOCK_TAG_STATE, var8);
                if (var6.nbt != null) {
                    ((NBTTagCompound)var7).put("nbt", var6.nbt);
                }
                nBTTagList.add(var7);
                for (int var9 = 1; var9 < this.palettes.size(); ++var9) {
                    var10 = (b)var1.get(var9);
                    ((b)var10).addMapping(this.palettes.get((int)var9).blocks().get((int)var5).state, var8);
                }
            }
            var0.put(BLOCKS_TAG, nBTTagList);
            if (var1.size() == 1) {
                var5 = new NBTTagList();
                for (Object var7 : var2) {
                    var5.add(GameProfileSerializer.writeBlockState((IBlockData)var7));
                }
                var0.put(PALETTE_TAG, var5);
            } else {
                var5 = new NBTTagList();
                for (Object var7 : var1) {
                    NBTTagList var8 = new NBTTagList();
                    Iterator<IBlockData> iterator = ((b)var7).iterator();
                    while (iterator.hasNext()) {
                        var10 = iterator.next();
                        var8.add(GameProfileSerializer.writeBlockState((IBlockData)var10));
                    }
                    var5.add(var8);
                }
                var0.put(PALETTE_LIST_TAG, var5);
            }
        }
        var1 = new NBTTagList();
        for (EntityInfo entityInfo : this.entityInfoList) {
            var4 = new NBTTagCompound();
            ((NBTTagCompound)var4).put("pos", this.newDoubleList(entityInfo.pos.x, entityInfo.pos.y, entityInfo.pos.z));
            ((NBTTagCompound)var4).put(ENTITY_TAG_BLOCKPOS, this.newIntegerList(entityInfo.blockPos.getX(), entityInfo.blockPos.getY(), entityInfo.blockPos.getZ()));
            if (entityInfo.nbt != null) {
                ((NBTTagCompound)var4).put("nbt", entityInfo.nbt);
            }
            var1.add(var4);
        }
        var0.put(ENTITIES_TAG, (NBTBase)((Object)var1));
        var0.put(SIZE_TAG, this.newIntegerList(this.size.getX(), this.size.getY(), this.size.getZ()));
        return GameProfileSerializer.addCurrentDataVersion(var0);
    }

    public void load(HolderGetter<Block> var0, NBTTagCompound var1) {
        int var5;
        NBTTagList var4;
        this.palettes.clear();
        this.entityInfoList.clear();
        NBTTagList var2 = var1.getList(SIZE_TAG, 3);
        this.size = new BaseBlockPosition(var2.getInt(0), var2.getInt(1), var2.getInt(2));
        NBTTagList var3 = var1.getList(BLOCKS_TAG, 10);
        if (var1.contains(PALETTE_LIST_TAG, 9)) {
            var4 = var1.getList(PALETTE_LIST_TAG, 9);
            for (var5 = 0; var5 < var4.size(); ++var5) {
                this.loadPalette(var0, var4.getList(var5), var3);
            }
        } else {
            this.loadPalette(var0, var1.getList(PALETTE_TAG, 10), var3);
        }
        var4 = var1.getList(ENTITIES_TAG, 10);
        for (var5 = 0; var5 < var4.size(); ++var5) {
            NBTTagCompound var6 = var4.getCompound(var5);
            NBTTagList var7 = var6.getList("pos", 6);
            Vec3D var8 = new Vec3D(var7.getDouble(0), var7.getDouble(1), var7.getDouble(2));
            NBTTagList var9 = var6.getList(ENTITY_TAG_BLOCKPOS, 3);
            BlockPosition var10 = new BlockPosition(var9.getInt(0), var9.getInt(1), var9.getInt(2));
            if (!var6.contains("nbt")) continue;
            NBTTagCompound var11 = var6.getCompound("nbt");
            this.entityInfoList.add(new EntityInfo(var8, var10, var11));
        }
    }

    private void loadPalette(HolderGetter<Block> var0, NBTTagList var1, NBTTagList var2) {
        b var3 = new b();
        for (int var4 = 0; var4 < var1.size(); ++var4) {
            var3.addMapping(GameProfileSerializer.readBlockState(var0, var1.getCompound(var4)), var4);
        }
        ArrayList var4 = Lists.newArrayList();
        ArrayList var5 = Lists.newArrayList();
        ArrayList var6 = Lists.newArrayList();
        for (int var7 = 0; var7 < var2.size(); ++var7) {
            NBTTagCompound var8 = var2.getCompound(var7);
            NBTTagList var9 = var8.getList("pos", 3);
            BlockPosition var10 = new BlockPosition(var9.getInt(0), var9.getInt(1), var9.getInt(2));
            IBlockData var11 = var3.stateFor(var8.getInt(BLOCK_TAG_STATE));
            NBTTagCompound var12 = var8.contains("nbt") ? var8.getCompound("nbt") : null;
            BlockInfo var13 = new BlockInfo(var10, var11, var12);
            DefinedStructure.addToLists(var13, var4, var5, var6);
        }
        List<BlockInfo> var7 = DefinedStructure.buildInfoList(var4, var5, var6);
        this.palettes.add(new a(var7));
    }

    private NBTTagList newIntegerList(int ... var0) {
        NBTTagList var1 = new NBTTagList();
        for (int var5 : var0) {
            var1.add(NBTTagInt.valueOf(var5));
        }
        return var1;
    }

    private NBTTagList newDoubleList(double ... var0) {
        NBTTagList var1 = new NBTTagList();
        for (double var5 : var0) {
            var1.add(NBTTagDouble.valueOf(var5));
        }
        return var1;
    }

    public static final class BlockInfo
    extends Record {
        final BlockPosition pos;
        final IBlockData state;
        @Nullable
        final NBTTagCompound nbt;

        public BlockInfo(BlockPosition var0, IBlockData var1, @Nullable NBTTagCompound var2) {
            this.pos = var0;
            this.state = var1;
            this.nbt = var2;
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.pos, this.state, this.nbt);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "pos", "state", "nbt"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "pos", "state", "nbt"}, this, var0);
        }

        public BlockPosition pos() {
            return this.pos;
        }

        public IBlockData state() {
            return this.state;
        }

        @Nullable
        public NBTTagCompound nbt() {
            return this.nbt;
        }
    }

    public static final class a {
        private final List<BlockInfo> blocks;
        private final Map<Block, List<BlockInfo>> cache = Maps.newHashMap();

        a(List<BlockInfo> var0) {
            this.blocks = var0;
        }

        public List<BlockInfo> blocks() {
            return this.blocks;
        }

        public List<BlockInfo> blocks(Block var02) {
            return this.cache.computeIfAbsent(var02, var0 -> this.blocks.stream().filter(var1 -> var1.state.is((Block)var0)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3D pos;
        public final BlockPosition blockPos;
        public final NBTTagCompound nbt;

        public EntityInfo(Vec3D var0, BlockPosition var1, NBTTagCompound var2) {
            this.pos = var0;
            this.blockPos = var1;
            this.nbt = var2;
        }
    }

    static class b
    implements Iterable<IBlockData> {
        public static final IBlockData DEFAULT_BLOCK_STATE = Blocks.AIR.defaultBlockState();
        private final RegistryBlockID<IBlockData> ids = new RegistryBlockID(16);
        private int lastId;

        b() {
        }

        public int idFor(IBlockData var0) {
            int var1 = this.ids.getId(var0);
            if (var1 == -1) {
                var1 = this.lastId++;
                this.ids.addMapping(var0, var1);
            }
            return var1;
        }

        @Nullable
        public IBlockData stateFor(int var0) {
            IBlockData var1 = this.ids.byId(var0);
            return var1 == null ? DEFAULT_BLOCK_STATE : var1;
        }

        @Override
        public Iterator<IBlockData> iterator() {
            return this.ids.iterator();
        }

        public void addMapping(IBlockData var0, int var1) {
            this.ids.addMapping(var0, var1);
        }
    }
}

