/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.structures.IglooPieces;

public class IglooStructure
extends Structure {
    public static final Codec<IglooStructure> CODEC = IglooStructure.simpleCodec(IglooStructure::new);

    public IglooStructure(Structure.c var0) {
        super(var0);
    }

    @Override
    public Optional<Structure.b> findGenerationPoint(Structure.a var0) {
        return IglooStructure.onTopOfChunkCenter(var0, HeightMap.Type.WORLD_SURFACE_WG, var1 -> this.generatePieces((StructurePiecesBuilder)var1, var0));
    }

    private void generatePieces(StructurePiecesBuilder var0, Structure.a var1) {
        ChunkCoordIntPair var2 = var1.chunkPos();
        SeededRandom var3 = var1.random();
        BlockPosition var4 = new BlockPosition(var2.getMinBlockX(), 90, var2.getMinBlockZ());
        EnumBlockRotation var5 = EnumBlockRotation.getRandom(var3);
        IglooPieces.addPieces(var1.structureTemplateManager(), var4, var5, var0, var3);
    }

    @Override
    public StructureType<?> type() {
        return StructureType.IGLOO;
    }
}

