/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.storage.loot.LootTables;

public class BuriedTreasurePieces {

    public static class a
    extends StructurePiece {
        public a(BlockPosition var0) {
            super(WorldGenFeatureStructurePieceType.BURIED_TREASURE_PIECE, 0, new StructureBoundingBox(var0));
        }

        public a(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.BURIED_TREASURE_PIECE, var0);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var7 = var0.getHeight(HeightMap.Type.OCEAN_FLOOR_WG, this.boundingBox.minX(), this.boundingBox.minZ());
            BlockPosition.MutableBlockPosition var8 = new BlockPosition.MutableBlockPosition(this.boundingBox.minX(), var7, this.boundingBox.minZ());
            while (var8.getY() > var0.getMinBuildHeight()) {
                IBlockData var9 = var0.getBlockState(var8);
                IBlockData var10 = var0.getBlockState((BlockPosition)var8.below());
                if (var10 == Blocks.SANDSTONE.defaultBlockState() || var10 == Blocks.STONE.defaultBlockState() || var10 == Blocks.ANDESITE.defaultBlockState() || var10 == Blocks.GRANITE.defaultBlockState() || var10 == Blocks.DIORITE.defaultBlockState()) {
                    IBlockData var11 = var9.isAir() || this.isLiquid(var9) ? Blocks.SAND.defaultBlockState() : var9;
                    for (EnumDirection var15 : EnumDirection.values()) {
                        BaseBlockPosition var16 = var8.relative(var15);
                        IBlockData var17 = var0.getBlockState((BlockPosition)var16);
                        if (!var17.isAir() && !this.isLiquid(var17)) continue;
                        BlockPosition var18 = ((BlockPosition)var16).below();
                        IBlockData var19 = var0.getBlockState(var18);
                        if ((var19.isAir() || this.isLiquid(var19)) && var15 != EnumDirection.UP) {
                            var0.setBlock((BlockPosition)var16, var10, 3);
                            continue;
                        }
                        var0.setBlock((BlockPosition)var16, var11, 3);
                    }
                    this.boundingBox = new StructureBoundingBox(var8);
                    this.createChest(var0, var4, var3, var8, LootTables.BURIED_TREASURE, null);
                    return;
                }
                var8.move(0, -1, 0);
            }
        }

        private boolean isLiquid(IBlockData var0) {
            return var0 == Blocks.WATER.defaultBlockState() || var0 == Blocks.LAVA.defaultBlockState();
        }
    }
}

