/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.Optionull;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorJigsawReplacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolSingle
extends WorldGenFeatureDefinedStructurePoolStructure {
    private static final Codec<Either<MinecraftKey, DefinedStructure>> TEMPLATE_CODEC = Codec.of(WorldGenFeatureDefinedStructurePoolSingle::encodeTemplate, (Decoder)MinecraftKey.CODEC.map(Either::left));
    public static final Codec<WorldGenFeatureDefinedStructurePoolSingle> CODEC = RecordCodecBuilder.create(var0 -> var0.group(WorldGenFeatureDefinedStructurePoolSingle.templateCodec(), WorldGenFeatureDefinedStructurePoolSingle.processorsCodec(), WorldGenFeatureDefinedStructurePoolSingle.projectionCodec()).apply((Applicative)var0, WorldGenFeatureDefinedStructurePoolSingle::new));
    protected final Either<MinecraftKey, DefinedStructure> template;
    protected final Holder<ProcessorList> processors;

    private static <T> DataResult<T> encodeTemplate(Either<MinecraftKey, DefinedStructure> var0, DynamicOps<T> var1, T var2) {
        Optional var3 = var0.left();
        if (var3.isEmpty()) {
            return DataResult.error(() -> "Can not serialize a runtime pool element");
        }
        return MinecraftKey.CODEC.encode((Object)((MinecraftKey)var3.get()), var1, var2);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Holder<ProcessorList>> processorsCodec() {
        return DefinedStructureStructureProcessorType.LIST_CODEC.fieldOf("processors").forGetter(var0 -> var0.processors);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Either<MinecraftKey, DefinedStructure>> templateCodec() {
        return TEMPLATE_CODEC.fieldOf("location").forGetter(var0 -> var0.template);
    }

    protected WorldGenFeatureDefinedStructurePoolSingle(Either<MinecraftKey, DefinedStructure> var0, Holder<ProcessorList> var1, WorldGenFeatureDefinedStructurePoolTemplate.Matching var2) {
        super(var2);
        this.template = var0;
        this.processors = var1;
    }

    @Override
    public BaseBlockPosition getSize(StructureTemplateManager var0, EnumBlockRotation var1) {
        DefinedStructure var2 = this.getTemplate(var0);
        return var2.getSize(var1);
    }

    private DefinedStructure getTemplate(StructureTemplateManager var0) {
        return (DefinedStructure)this.template.map(var0::getOrCreate, Function.identity());
    }

    public List<DefinedStructure.BlockInfo> getDataMarkers(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, boolean var3) {
        DefinedStructure var4 = this.getTemplate(var0);
        ObjectArrayList<DefinedStructure.BlockInfo> var5 = var4.filterBlocks(var1, new DefinedStructureInfo().setRotation(var2), Blocks.STRUCTURE_BLOCK, var3);
        ArrayList var6 = Lists.newArrayList();
        for (DefinedStructure.BlockInfo var8 : var5) {
            BlockPropertyStructureMode var10;
            NBTTagCompound var9 = var8.nbt();
            if (var9 == null || (var10 = BlockPropertyStructureMode.valueOf(var9.getString("mode"))) != BlockPropertyStructureMode.DATA) continue;
            var6.add(var8);
        }
        return var6;
    }

    @Override
    public List<DefinedStructure.BlockInfo> getShuffledJigsawBlocks(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2, RandomSource var3) {
        DefinedStructure var4 = this.getTemplate(var0);
        ObjectArrayList<DefinedStructure.BlockInfo> var5 = var4.filterBlocks(var1, new DefinedStructureInfo().setRotation(var2), Blocks.JIGSAW, true);
        SystemUtils.shuffle(var5, var3);
        WorldGenFeatureDefinedStructurePoolSingle.sortBySelectionPriority(var5);
        return var5;
    }

    @VisibleForTesting
    static void sortBySelectionPriority(List<DefinedStructure.BlockInfo> var0) {
        var0.sort(Comparator.comparingInt(var02 -> Optionull.mapOrDefault(var02.nbt(), var0 -> var0.getInt("selection_priority"), 0)).reversed());
    }

    @Override
    public StructureBoundingBox getBoundingBox(StructureTemplateManager var0, BlockPosition var1, EnumBlockRotation var2) {
        DefinedStructure var3 = this.getTemplate(var0);
        return var3.getBoundingBox(new DefinedStructureInfo().setRotation(var2), var1);
    }

    @Override
    public boolean place(StructureTemplateManager var0, GeneratorAccessSeed var1, StructureManager var2, ChunkGenerator var3, BlockPosition var4, BlockPosition var5, EnumBlockRotation var6, StructureBoundingBox var7, RandomSource var8, boolean var9) {
        DefinedStructureInfo var11;
        DefinedStructure var10 = this.getTemplate(var0);
        if (var10.placeInWorld(var1, var4, var5, var11 = this.getSettings(var6, var7, var9), var8, 18)) {
            List<DefinedStructure.BlockInfo> var12 = DefinedStructure.processBlockInfos(var1, var4, var5, var11, this.getDataMarkers(var0, var4, var6, false));
            for (DefinedStructure.BlockInfo var14 : var12) {
                this.handleDataMarker(var1, var14, var4, var6, var8, var7);
            }
            return true;
        }
        return false;
    }

    protected DefinedStructureInfo getSettings(EnumBlockRotation var0, StructureBoundingBox var1, boolean var2) {
        DefinedStructureInfo var3 = new DefinedStructureInfo();
        var3.setBoundingBox(var1);
        var3.setRotation(var0);
        var3.setKnownShape(true);
        var3.setIgnoreEntities(false);
        var3.addProcessor(DefinedStructureProcessorBlockIgnore.STRUCTURE_BLOCK);
        var3.setFinalizeEntities(true);
        if (!var2) {
            var3.addProcessor(DefinedStructureProcessorJigsawReplacement.INSTANCE);
        }
        this.processors.value().list().forEach(var3::addProcessor);
        this.getProjection().getProcessors().forEach(var3::addProcessor);
        return var3;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> getType() {
        return WorldGenFeatureDefinedStructurePools.SINGLE;
    }

    public String toString() {
        return "Single[" + this.template + "]";
    }
}

