/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SequencedPriorityIterator;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolEmpty;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class WorldGenFeatureDefinedStructureJigsawPlacement {
    static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.b> addPieces(Structure.a var02, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, Optional<MinecraftKey> var22, int var3, BlockPosition var4, boolean var5, Optional<HeightMap.Type> var6, int var7, PoolAliasLookup var8) {
        BlockPosition var18;
        Optional<BlockPosition> var20;
        Comparable<MinecraftKey> var19;
        IRegistryCustom var9 = var02.registryAccess();
        ChunkGenerator var10 = var02.chunkGenerator();
        StructureTemplateManager var11 = var02.structureTemplateManager();
        LevelHeightAccessor var12 = var02.heightAccessor();
        SeededRandom var13 = var02.random();
        IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var14 = var9.registryOrThrow(Registries.TEMPLATE_POOL);
        EnumBlockRotation var152 = EnumBlockRotation.getRandom(var13);
        WorldGenFeatureDefinedStructurePoolTemplate var16 = var1.unwrapKey().flatMap(var2 -> var14.getOptional(var8.lookup((ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>)var2))).orElse(var1.value());
        WorldGenFeatureDefinedStructurePoolStructure var17 = var16.getRandomTemplate(var13);
        if (var17 == WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
            return Optional.empty();
        }
        if (var22.isPresent()) {
            var19 = var22.get();
            var20 = WorldGenFeatureDefinedStructureJigsawPlacement.getRandomNamedJigsaw(var17, (MinecraftKey)var19, var4, var152, var11, var13);
            if (var20.isEmpty()) {
                LOGGER.error("No starting jigsaw {} found in start pool {}", (Object)var19, (Object)var1.unwrapKey().map(var0 -> var0.location().toString()).orElse("<unregistered>"));
                return Optional.empty();
            }
            var18 = (BlockPosition)var20.get();
        } else {
            var18 = var4;
        }
        var19 = var18.subtract(var4);
        var20 = var4.subtract((BaseBlockPosition)var19);
        WorldGenFeaturePillagerOutpostPoolPiece var21 = new WorldGenFeaturePillagerOutpostPoolPiece(var11, var17, (BlockPosition)((Object)var20), var17.getGroundLevelDelta(), var152, var17.getBoundingBox(var11, (BlockPosition)((Object)var20), var152));
        StructureBoundingBox var222 = var21.getBoundingBox();
        int var23 = (var222.maxX() + var222.minX()) / 2;
        int var24 = (var222.maxZ() + var222.minZ()) / 2;
        int var25 = var6.isPresent() ? var4.getY() + var10.getFirstFreeHeight(var23, var24, var6.get(), var12, var02.randomState()) : ((BaseBlockPosition)((Object)var20)).getY();
        int var26 = var222.minY() + var21.getGroundLevelDelta();
        var21.move(0, var25 - var26, 0);
        int var27 = var25 + ((BaseBlockPosition)var19).getY();
        return Optional.of(new Structure.b(new BlockPosition(var23, var27, var24), var15 -> {
            ArrayList var16 = Lists.newArrayList();
            var16.add(var21);
            if (var3 <= 0) {
                return;
            }
            AxisAlignedBB var17 = new AxisAlignedBB(var23 - var7, var27 - var7, var24 - var7, var23 + var7 + 1, var27 + var7 + 1, var24 + var7 + 1);
            VoxelShape var18 = VoxelShapes.join(VoxelShapes.create(var17), VoxelShapes.create(AxisAlignedBB.of(var222)), OperatorBoolean.ONLY_FIRST);
            WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var02.randomState(), var3, var5, var10, var11, var12, var13, var14, var21, var16, var18, var8);
            var16.forEach(var15::addPiece);
        }));
    }

    private static Optional<BlockPosition> getRandomNamedJigsaw(WorldGenFeatureDefinedStructurePoolStructure var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, StructureTemplateManager var4, SeededRandom var5) {
        List<DefinedStructure.BlockInfo> var6 = var0.getShuffledJigsawBlocks(var4, var2, var3, var5);
        Optional<BlockPosition> var7 = Optional.empty();
        for (DefinedStructure.BlockInfo var9 : var6) {
            MinecraftKey var10 = MinecraftKey.tryParse(Objects.requireNonNull(var9.nbt(), () -> var9 + " nbt was null").getString("name"));
            if (!var1.equals(var10)) continue;
            var7 = Optional.of(var9.pos());
            break;
        }
        return var7;
    }

    private static void addPieces(RandomState var0, int var1, boolean var2, ChunkGenerator var3, StructureTemplateManager var4, LevelHeightAccessor var5, RandomSource var6, IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var7, WorldGenFeaturePillagerOutpostPoolPiece var8, List<WorldGenFeaturePillagerOutpostPoolPiece> var9, VoxelShape var10, PoolAliasLookup var11) {
        b var12 = new b(var7, var1, var3, var4, var9, var6);
        var12.tryPlacingChildren(var8, (MutableObject<VoxelShape>)new MutableObject((Object)var10), 0, var2, var5, var0, var11);
        while (var12.placing.hasNext()) {
            a var13 = (a)var12.placing.next();
            var12.tryPlacingChildren(var13.piece, var13.free, var13.depth, var2, var5, var0, var11);
        }
    }

    public static boolean generateJigsaw(WorldServer var02, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, MinecraftKey var2, int var3, BlockPosition var4, boolean var5) {
        ChunkGenerator var6 = var02.getChunkSource().getGenerator();
        StructureTemplateManager var7 = var02.getStructureManager();
        StructureManager var8 = var02.structureManager();
        RandomSource var9 = var02.getRandom();
        Structure.a var10 = new Structure.a(var02.registryAccess(), var6, var6.getBiomeSource(), var02.getChunkSource().randomState(), var7, var02.getSeed(), new ChunkCoordIntPair(var4), var02, var0 -> true);
        Optional<Structure.b> var11 = WorldGenFeatureDefinedStructureJigsawPlacement.addPieces(var10, var1, Optional.of(var2), var3, var4, false, Optional.empty(), 128, PoolAliasLookup.EMPTY);
        if (var11.isPresent()) {
            StructurePiecesBuilder var12 = var11.get().getPiecesBuilder();
            for (StructurePiece var14 : var12.build().pieces()) {
                if (!(var14 instanceof WorldGenFeaturePillagerOutpostPoolPiece)) continue;
                WorldGenFeaturePillagerOutpostPoolPiece var15 = (WorldGenFeaturePillagerOutpostPoolPiece)var14;
                var15.place(var02, var8, var6, var9, StructureBoundingBox.infinite(), var4, var5);
            }
            return true;
        }
        return false;
    }

    static final class b {
        private final IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> pools;
        private final int maxDepth;
        private final ChunkGenerator chunkGenerator;
        private final StructureTemplateManager structureTemplateManager;
        private final List<? super WorldGenFeaturePillagerOutpostPoolPiece> pieces;
        private final RandomSource random;
        final SequencedPriorityIterator<a> placing = new SequencedPriorityIterator();

        b(IRegistry<WorldGenFeatureDefinedStructurePoolTemplate> var0, int var1, ChunkGenerator var2, StructureTemplateManager var3, List<? super WorldGenFeaturePillagerOutpostPoolPiece> var4, RandomSource var5) {
            this.pools = var0;
            this.maxDepth = var1;
            this.chunkGenerator = var2;
            this.structureTemplateManager = var3;
            this.pieces = var4;
            this.random = var5;
        }

        void tryPlacingChildren(WorldGenFeaturePillagerOutpostPoolPiece var02, MutableObject<VoxelShape> var1, int var22, boolean var3, LevelHeightAccessor var4, RandomState var5, PoolAliasLookup var6) {
            WorldGenFeatureDefinedStructurePoolStructure var7 = var02.getElement();
            BlockPosition var8 = var02.getPosition();
            EnumBlockRotation var9 = var02.getRotation();
            WorldGenFeatureDefinedStructurePoolTemplate.Matching var10 = var7.getProjection();
            boolean var11 = var10 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
            MutableObject<VoxelShape> var12 = new MutableObject<VoxelShape>();
            StructureBoundingBox var13 = var02.getBoundingBox();
            int var14 = var13.minY();
            block0: for (DefinedStructure.BlockInfo var16 : var7.getShuffledJigsawBlocks(this.structureTemplateManager, var8, var9, this.random)) {
                WorldGenFeatureDefinedStructurePoolStructure var31;
                MutableObject<VoxelShape> var26;
                EnumDirection var17 = BlockJigsaw.getFrontFacing(var16.state());
                BlockPosition var18 = var16.pos();
                BlockPosition var19 = var18.relative(var17);
                int var20 = var18.getY() - var14;
                int var21 = -1;
                ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var222 = b.readPoolKey(var16, var6);
                Optional<Holder.c<WorldGenFeatureDefinedStructurePoolTemplate>> var23 = this.pools.getHolder(var222);
                if (var23.isEmpty()) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var222.location());
                    continue;
                }
                Holder var24 = var23.get();
                if (((WorldGenFeatureDefinedStructurePoolTemplate)var24.value()).size() == 0 && !var24.is(WorldGenFeaturePieces.EMPTY)) {
                    LOGGER.warn("Empty or non-existent pool: {}", (Object)var222.location());
                    continue;
                }
                Holder<WorldGenFeatureDefinedStructurePoolTemplate> var25 = ((WorldGenFeatureDefinedStructurePoolTemplate)var24.value()).getFallback();
                if (var25.value().size() == 0 && !var25.is(WorldGenFeaturePieces.EMPTY)) {
                    LOGGER.warn("Empty or non-existent fallback pool: {}", (Object)var25.unwrapKey().map(var0 -> var0.location().toString()).orElse("<unregistered>"));
                    continue;
                }
                boolean var27 = var13.isInside(var19);
                if (var27) {
                    var26 = var12;
                    if (var12.getValue() == null) {
                        var12.setValue((Object)VoxelShapes.create(AxisAlignedBB.of(var13)));
                    }
                } else {
                    var26 = var1;
                }
                ArrayList var28 = Lists.newArrayList();
                if (var22 != this.maxDepth) {
                    var28.addAll(((WorldGenFeatureDefinedStructurePoolTemplate)var24.value()).getShuffledTemplates(this.random));
                }
                var28.addAll(var25.value().getShuffledTemplates(this.random));
                int var29 = var16.nbt() != null ? var16.nbt().getInt("placement_priority") : 0;
                Iterator iterator = var28.iterator();
                while (iterator.hasNext() && (var31 = (WorldGenFeatureDefinedStructurePoolStructure)iterator.next()) != WorldGenFeatureDefinedStructurePoolEmpty.INSTANCE) {
                    for (EnumBlockRotation var33 : EnumBlockRotation.getShuffled(this.random)) {
                        List<DefinedStructure.BlockInfo> var34 = var31.getShuffledJigsawBlocks(this.structureTemplateManager, BlockPosition.ZERO, var33, this.random);
                        StructureBoundingBox var35 = var31.getBoundingBox(this.structureTemplateManager, BlockPosition.ZERO, var33);
                        int var36 = !var3 || var35.getYSpan() > 16 ? 0 : var34.stream().mapToInt(var2 -> {
                            if (!var35.isInside(var2.pos().relative(BlockJigsaw.getFrontFacing(var2.state())))) {
                                return 0;
                            }
                            ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var3 = b.readPoolKey(var2, var6);
                            Optional<Holder.c<WorldGenFeatureDefinedStructurePoolTemplate>> var4 = this.pools.getHolder(var3);
                            Optional<Holder> var5 = var4.map(var0 -> ((WorldGenFeatureDefinedStructurePoolTemplate)var0.value()).getFallback());
                            int var6 = var4.map(var0 -> ((WorldGenFeatureDefinedStructurePoolTemplate)var0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            int var7 = var5.map(var0 -> ((WorldGenFeatureDefinedStructurePoolTemplate)var0.value()).getMaxSize(this.structureTemplateManager)).orElse(0);
                            return Math.max(var6, var7);
                        }).max().orElse(0);
                        for (DefinedStructure.BlockInfo var38 : var34) {
                            int var54;
                            int var51;
                            int var47;
                            if (!BlockJigsaw.canAttach(var16, var38)) continue;
                            BlockPosition var39 = var38.pos();
                            BlockPosition var40 = var19.subtract(var39);
                            StructureBoundingBox var41 = var31.getBoundingBox(this.structureTemplateManager, var40, var33);
                            int var42 = var41.minY();
                            WorldGenFeatureDefinedStructurePoolTemplate.Matching var43 = var31.getProjection();
                            boolean var44 = var43 == WorldGenFeatureDefinedStructurePoolTemplate.Matching.RIGID;
                            int var45 = var39.getY();
                            int var46 = var20 - var45 + BlockJigsaw.getFrontFacing(var16.state()).getStepY();
                            if (var11 && var44) {
                                var47 = var14 + var46;
                            } else {
                                if (var21 == -1) {
                                    var21 = this.chunkGenerator.getFirstFreeHeight(var18.getX(), var18.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4, var5);
                                }
                                var47 = var21 - var45;
                            }
                            int var48 = var47 - var42;
                            StructureBoundingBox var49 = var41.moved(0, var48, 0);
                            BlockPosition var50 = var40.offset(0, var48, 0);
                            if (var36 > 0) {
                                var51 = Math.max(var36 + 1, var49.maxY() - var49.minY());
                                var49.encapsulate(new BlockPosition(var49.minX(), var49.minY() + var51, var49.minZ()));
                            }
                            if (VoxelShapes.joinIsNotEmpty((VoxelShape)var26.getValue(), VoxelShapes.create(AxisAlignedBB.of(var49).deflate(0.25)), OperatorBoolean.ONLY_SECOND)) continue;
                            var26.setValue((Object)VoxelShapes.joinUnoptimized((VoxelShape)var26.getValue(), VoxelShapes.create(AxisAlignedBB.of(var49)), OperatorBoolean.ONLY_FIRST));
                            var51 = var02.getGroundLevelDelta();
                            int var52 = var44 ? var51 - var46 : var31.getGroundLevelDelta();
                            WorldGenFeaturePillagerOutpostPoolPiece var53 = new WorldGenFeaturePillagerOutpostPoolPiece(this.structureTemplateManager, var31, var50, var52, var33, var49);
                            if (var11) {
                                var54 = var14 + var20;
                            } else if (var44) {
                                var54 = var47 + var45;
                            } else {
                                if (var21 == -1) {
                                    var21 = this.chunkGenerator.getFirstFreeHeight(var18.getX(), var18.getZ(), HeightMap.Type.WORLD_SURFACE_WG, var4, var5);
                                }
                                var54 = var21 + var46 / 2;
                            }
                            var02.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var19.getX(), var54 - var20 + var51, var19.getZ(), var46, var43));
                            var53.addJunction(new WorldGenFeatureDefinedStructureJigsawJunction(var18.getX(), var54 - var45 + var52, var18.getZ(), -var46, var10));
                            this.pieces.add(var53);
                            if (var22 + 1 > this.maxDepth) continue block0;
                            a var55 = new a(var53, var26, var22 + 1);
                            this.placing.add(var55, var29);
                            continue block0;
                        }
                    }
                }
            }
        }

        private static ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> readPoolKey(DefinedStructure.BlockInfo var0, PoolAliasLookup var1) {
            NBTTagCompound var2 = Objects.requireNonNull(var0.nbt(), () -> var0 + " nbt was null");
            ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var3 = WorldGenFeaturePieces.createKey(var2.getString("pool"));
            return var1.lookup(var3);
        }
    }

    static final class a
    extends Record {
        final WorldGenFeaturePillagerOutpostPoolPiece piece;
        final MutableObject<VoxelShape> free;
        final int depth;

        a(WorldGenFeaturePillagerOutpostPoolPiece var0, MutableObject<VoxelShape> var1, int var2) {
            this.piece = var0;
            this.free = var1;
            this.depth = var2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "piece;free;depth", "piece", "free", "depth"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "piece;free;depth", "piece", "free", "depth"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "piece;free;depth", "piece", "free", "depth"}, this, var0);
        }

        public WorldGenFeaturePillagerOutpostPoolPiece piece() {
            return this.piece;
        }

        public MutableObject<VoxelShape> free() {
            return this.free;
        }

        public int depth() {
            return this.depth;
        }
    }
}

