/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureHugeFungiConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureWeepingVines;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;

public class WorldGenFeatureHugeFungi
extends WorldGenerator<WorldGenFeatureHugeFungiConfiguration> {
    private static final float HUGE_PROBABILITY = 0.06f;

    public WorldGenFeatureHugeFungi(Codec<WorldGenFeatureHugeFungiConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<WorldGenFeatureHugeFungiConfiguration> var0) {
        GeneratorAccessSeed var1 = var0.level();
        BlockPosition var2 = var0.origin();
        RandomSource var3 = var0.random();
        ChunkGenerator var4 = var0.chunkGenerator();
        WorldGenFeatureHugeFungiConfiguration var5 = var0.config();
        Block var6 = var5.validBaseState.getBlock();
        BlockPosition var7 = null;
        IBlockData var8 = var1.getBlockState(var2.below());
        if (var8.is(var6)) {
            var7 = var2;
        }
        if (var7 == null) {
            return false;
        }
        int var9 = MathHelper.nextInt(var3, 4, 13);
        if (var3.nextInt(12) == 0) {
            var9 *= 2;
        }
        if (!var5.planted) {
            int n2 = var4.getGenDepth();
            if (var7.getY() + var9 + 1 >= n2) {
                return false;
            }
        }
        boolean bl = !var5.planted && var3.nextFloat() < 0.06f;
        var1.setBlock(var2, Blocks.AIR.defaultBlockState(), 4);
        this.placeStem(var1, var3, var5, var7, var9, bl);
        this.placeHat(var1, var3, var5, var7, var9, bl);
        return true;
    }

    private static boolean isReplaceable(GeneratorAccessSeed var0, BlockPosition var1, WorldGenFeatureHugeFungiConfiguration var2, boolean var3) {
        if (var0.isStateAtPosition(var1, BlockBase.BlockData::canBeReplaced)) {
            return true;
        }
        if (var3) {
            return var2.replaceableBlocks.test(var0, var1);
        }
        return false;
    }

    private void placeStem(GeneratorAccessSeed var0, RandomSource var1, WorldGenFeatureHugeFungiConfiguration var2, BlockPosition var3, int var4, boolean var5) {
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        IBlockData var7 = var2.stemState;
        int var8 = var5 ? 1 : 0;
        for (int var9 = -var8; var9 <= var8; ++var9) {
            for (int var10 = -var8; var10 <= var8; ++var10) {
                boolean var11 = var5 && MathHelper.abs(var9) == var8 && MathHelper.abs(var10) == var8;
                for (int var12 = 0; var12 < var4; ++var12) {
                    var6.setWithOffset(var3, var9, var12, var10);
                    if (!WorldGenFeatureHugeFungi.isReplaceable(var0, var6, var2, true)) continue;
                    if (var2.planted) {
                        if (!var0.getBlockState((BlockPosition)var6.below()).isAir()) {
                            var0.destroyBlock(var6, true);
                        }
                        var0.setBlock(var6, var7, 3);
                        continue;
                    }
                    if (var11) {
                        if (!(var1.nextFloat() < 0.1f)) continue;
                        this.setBlock(var0, var6, var7);
                        continue;
                    }
                    this.setBlock(var0, var6, var7);
                }
            }
        }
    }

    private void placeHat(GeneratorAccessSeed var0, RandomSource var1, WorldGenFeatureHugeFungiConfiguration var2, BlockPosition var3, int var4, boolean var5) {
        int var9;
        BlockPosition.MutableBlockPosition var6 = new BlockPosition.MutableBlockPosition();
        boolean var7 = var2.hatState.is(Blocks.NETHER_WART_BLOCK);
        int var8 = Math.min(var1.nextInt(1 + var4 / 3) + 5, var4);
        for (int var10 = var9 = var4 - var8; var10 <= var4; ++var10) {
            int var11;
            int n2 = var11 = var10 < var4 - var1.nextInt(3) ? 2 : 1;
            if (var8 > 8 && var10 < var9 + 4) {
                var11 = 3;
            }
            if (var5) {
                ++var11;
            }
            for (int var12 = -var11; var12 <= var11; ++var12) {
                for (int var13 = -var11; var13 <= var11; ++var13) {
                    boolean var14 = var12 == -var11 || var12 == var11;
                    boolean var15 = var13 == -var11 || var13 == var11;
                    boolean var16 = !var14 && !var15 && var10 != var4;
                    boolean var17 = var14 && var15;
                    boolean var18 = var10 < var9 + 3;
                    var6.setWithOffset(var3, var12, var10, var13);
                    if (!WorldGenFeatureHugeFungi.isReplaceable(var0, var6, var2, false)) continue;
                    if (var2.planted && !var0.getBlockState((BlockPosition)var6.below()).isAir()) {
                        var0.destroyBlock(var6, true);
                    }
                    if (var18) {
                        if (var16) continue;
                        this.placeHatDropBlock(var0, var1, var6, var2.hatState, var7);
                        continue;
                    }
                    if (var16) {
                        this.placeHatBlock(var0, var1, var2, var6, 0.1f, 0.2f, var7 ? 0.1f : 0.0f);
                        continue;
                    }
                    if (var17) {
                        this.placeHatBlock(var0, var1, var2, var6, 0.01f, 0.7f, var7 ? 0.083f : 0.0f);
                        continue;
                    }
                    this.placeHatBlock(var0, var1, var2, var6, 5.0E-4f, 0.98f, var7 ? 0.07f : 0.0f);
                }
            }
        }
    }

    private void placeHatBlock(GeneratorAccess var0, RandomSource var1, WorldGenFeatureHugeFungiConfiguration var2, BlockPosition.MutableBlockPosition var3, float var4, float var5, float var6) {
        if (var1.nextFloat() < var4) {
            this.setBlock(var0, var3, var2.decorState);
        } else if (var1.nextFloat() < var5) {
            this.setBlock(var0, var3, var2.hatState);
            if (var1.nextFloat() < var6) {
                WorldGenFeatureHugeFungi.tryPlaceWeepingVines(var3, var0, var1);
            }
        }
    }

    private void placeHatDropBlock(GeneratorAccess var0, RandomSource var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.getBlockState(var2.below()).is(var3.getBlock())) {
            this.setBlock(var0, var2, var3);
        } else if ((double)var1.nextFloat() < 0.15) {
            this.setBlock(var0, var2, var3);
            if (var4 && var1.nextInt(11) == 0) {
                WorldGenFeatureHugeFungi.tryPlaceWeepingVines(var2, var0, var1);
            }
        }
    }

    private static void tryPlaceWeepingVines(BlockPosition var0, GeneratorAccess var1, RandomSource var2) {
        BlockPosition.MutableBlockPosition var3 = var0.mutable().move(EnumDirection.DOWN);
        if (!var1.isEmptyBlock(var3)) {
            return;
        }
        int var4 = MathHelper.nextInt(var2, 1, 5);
        if (var2.nextInt(7) == 0) {
            var4 *= 2;
        }
        int var5 = 23;
        int var6 = 25;
        WorldGenFeatureWeepingVines.placeWeepingVinesColumn(var1, var2, var3, var4, 23, 25);
    }
}

