/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Optional;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public interface VibrationSystem {
    public static final GameEvent[] RESONANCE_EVENTS = new GameEvent[]{GameEvent.RESONATE_1, GameEvent.RESONATE_2, GameEvent.RESONATE_3, GameEvent.RESONATE_4, GameEvent.RESONATE_5, GameEvent.RESONATE_6, GameEvent.RESONATE_7, GameEvent.RESONATE_8, GameEvent.RESONATE_9, GameEvent.RESONATE_10, GameEvent.RESONATE_11, GameEvent.RESONATE_12, GameEvent.RESONATE_13, GameEvent.RESONATE_14, GameEvent.RESONATE_15};
    public static final ToIntFunction<GameEvent> VIBRATION_FREQUENCY_FOR_EVENT = (ToIntFunction)SystemUtils.make(new Object2IntOpenHashMap(), var0 -> {
        var0.defaultReturnValue(0);
        var0.put((Object)GameEvent.STEP, 1);
        var0.put((Object)GameEvent.SWIM, 1);
        var0.put((Object)GameEvent.FLAP, 1);
        var0.put((Object)GameEvent.PROJECTILE_LAND, 2);
        var0.put((Object)GameEvent.HIT_GROUND, 2);
        var0.put((Object)GameEvent.SPLASH, 2);
        var0.put((Object)GameEvent.ITEM_INTERACT_FINISH, 3);
        var0.put((Object)GameEvent.PROJECTILE_SHOOT, 3);
        var0.put((Object)GameEvent.INSTRUMENT_PLAY, 3);
        var0.put((Object)GameEvent.ENTITY_ACTION, 4);
        var0.put((Object)GameEvent.ELYTRA_GLIDE, 4);
        var0.put((Object)GameEvent.UNEQUIP, 4);
        var0.put((Object)GameEvent.ENTITY_DISMOUNT, 5);
        var0.put((Object)GameEvent.EQUIP, 5);
        var0.put((Object)GameEvent.ENTITY_INTERACT, 6);
        var0.put((Object)GameEvent.SHEAR, 6);
        var0.put((Object)GameEvent.ENTITY_MOUNT, 6);
        var0.put((Object)GameEvent.ENTITY_DAMAGE, 7);
        var0.put((Object)GameEvent.DRINK, 8);
        var0.put((Object)GameEvent.EAT, 8);
        var0.put((Object)GameEvent.CONTAINER_CLOSE, 9);
        var0.put((Object)GameEvent.BLOCK_CLOSE, 9);
        var0.put((Object)GameEvent.BLOCK_DEACTIVATE, 9);
        var0.put((Object)GameEvent.BLOCK_DETACH, 9);
        var0.put((Object)GameEvent.CONTAINER_OPEN, 10);
        var0.put((Object)GameEvent.BLOCK_OPEN, 10);
        var0.put((Object)GameEvent.BLOCK_ACTIVATE, 10);
        var0.put((Object)GameEvent.BLOCK_ATTACH, 10);
        var0.put((Object)GameEvent.PRIME_FUSE, 10);
        var0.put((Object)GameEvent.NOTE_BLOCK_PLAY, 10);
        var0.put((Object)GameEvent.BLOCK_CHANGE, 11);
        var0.put((Object)GameEvent.BLOCK_DESTROY, 12);
        var0.put((Object)GameEvent.FLUID_PICKUP, 12);
        var0.put((Object)GameEvent.BLOCK_PLACE, 13);
        var0.put((Object)GameEvent.FLUID_PLACE, 13);
        var0.put((Object)GameEvent.ENTITY_PLACE, 14);
        var0.put((Object)GameEvent.LIGHTNING_STRIKE, 14);
        var0.put((Object)GameEvent.TELEPORT, 14);
        var0.put((Object)GameEvent.ENTITY_DIE, 15);
        var0.put((Object)GameEvent.EXPLODE, 15);
        for (int var1 = 1; var1 <= 15; ++var1) {
            var0.put((Object)VibrationSystem.getResonanceEventByFrequency(var1), var1);
        }
    });

    public a getVibrationData();

    public d getVibrationUser();

    public static int getGameEventFrequency(GameEvent var0) {
        return VIBRATION_FREQUENCY_FOR_EVENT.applyAsInt(var0);
    }

    public static GameEvent getResonanceEventByFrequency(int var0) {
        return RESONANCE_EVENTS[var0 - 1];
    }

    public static int getRedstoneStrengthForDistance(float var0, int var1) {
        double var2 = 15.0 / (double)var1;
        return Math.max(1, 15 - MathHelper.floor(var2 * (double)var0));
    }

    public static interface d {
        public int getListenerRadius();

        public PositionSource getPositionSource();

        public boolean canReceiveVibration(WorldServer var1, BlockPosition var2, GameEvent var3, GameEvent.a var4);

        public void onReceiveVibration(WorldServer var1, BlockPosition var2, GameEvent var3, @Nullable Entity var4, @Nullable Entity var5, float var6);

        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.VIBRATIONS;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean requiresAdjacentChunksToBeTicking() {
            return false;
        }

        default public int calculateTravelTimeInTicks(float var0) {
            return MathHelper.floor(var0);
        }

        default public boolean isValidVibration(GameEvent var0, GameEvent.a var1) {
            if (!var0.is(this.getListenableEvents())) {
                return false;
            }
            Entity var2 = var1.sourceEntity();
            if (var2 != null) {
                if (var2.isSpectator()) {
                    return false;
                }
                if (var2.isSteppingCarefully() && var0.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                    if (this.canTriggerAvoidVibration() && var2 instanceof EntityPlayer) {
                        EntityPlayer var3 = (EntityPlayer)var2;
                        CriterionTriggers.AVOID_VIBRATION.trigger(var3);
                    }
                    return false;
                }
                if (var2.dampensVibrations()) {
                    return false;
                }
            }
            if (var1.affectedState() != null) {
                return !var1.affectedState().is(TagsBlock.DAMPENS_VIBRATIONS);
            }
            return true;
        }

        default public void onDataChanged() {
        }
    }

    public static interface c {
        public static void tick(World var0, a var1, d var2) {
            if (!(var0 instanceof WorldServer)) {
                return;
            }
            WorldServer var3 = (WorldServer)var0;
            if (var1.currentVibration == null) {
                c.trySelectAndScheduleVibration(var3, var1, var2);
            }
            if (var1.currentVibration == null) {
                return;
            }
            boolean var4 = var1.getTravelTimeInTicks() > 0;
            c.tryReloadVibrationParticle(var3, var1, var2);
            var1.decrementTravelTime();
            if (var1.getTravelTimeInTicks() <= 0) {
                var4 = c.receiveVibration(var3, var1, var2, var1.currentVibration);
            }
            if (var4) {
                var2.onDataChanged();
            }
        }

        private static void trySelectAndScheduleVibration(WorldServer var0, a var1, d var2) {
            var1.getSelectionStrategy().chosenCandidate(var0.getGameTime()).ifPresent(var3 -> {
                var1.setCurrentVibration((VibrationInfo)var3);
                Vec3D var4 = var3.pos();
                var1.setTravelTimeInTicks(var2.calculateTravelTimeInTicks(var3.distance()));
                var0.sendParticles(new VibrationParticleOption(var2.getPositionSource(), var1.getTravelTimeInTicks()), var4.x, var4.y, var4.z, 1, 0.0, 0.0, 0.0, 0.0);
                var2.onDataChanged();
                var1.getSelectionStrategy().startOver();
            });
        }

        private static void tryReloadVibrationParticle(WorldServer var0, a var1, d var2) {
            double var14;
            double var12;
            int var7;
            double var8;
            double var10;
            boolean var16;
            if (!var1.shouldReloadVibrationParticle()) {
                return;
            }
            if (var1.currentVibration == null) {
                var1.setReloadVibrationParticle(false);
                return;
            }
            Vec3D var3 = var1.currentVibration.pos();
            PositionSource var4 = var2.getPositionSource();
            Vec3D var5 = var4.getPosition(var0).orElse(var3);
            int var6 = var1.getTravelTimeInTicks();
            boolean bl = var16 = var0.sendParticles(new VibrationParticleOption(var4, var6), var10 = MathHelper.lerp(var8 = 1.0 - (double)var6 / (double)(var7 = var2.calculateTravelTimeInTicks(var1.currentVibration.distance())), var3.x, var5.x), var12 = MathHelper.lerp(var8, var3.y, var5.y), var14 = MathHelper.lerp(var8, var3.z, var5.z), 1, 0.0, 0.0, 0.0, 0.0) > 0;
            if (var16) {
                var1.setReloadVibrationParticle(false);
            }
        }

        private static boolean receiveVibration(WorldServer var0, a var1, d var2, VibrationInfo var3) {
            BlockPosition var4 = BlockPosition.containing(var3.pos());
            BlockPosition var5 = var2.getPositionSource().getPosition(var0).map(BlockPosition::containing).orElse(var4);
            if (var2.requiresAdjacentChunksToBeTicking() && !c.areAdjacentChunksTicking(var0, var5)) {
                return false;
            }
            var2.onReceiveVibration(var0, var4, var3.gameEvent(), var3.getEntity(var0).orElse(null), var3.getProjectileOwner(var0).orElse(null), b.distanceBetweenInBlocks(var4, var5));
            var1.setCurrentVibration(null);
            return true;
        }

        private static boolean areAdjacentChunksTicking(World var0, BlockPosition var1) {
            ChunkCoordIntPair var2 = new ChunkCoordIntPair(var1);
            for (int var3 = var2.x - 1; var3 <= var2.x + 1; ++var3) {
                for (int var4 = var2.z - 1; var4 <= var2.z + 1; ++var4) {
                    if (var0.shouldTickBlocksAt(ChunkCoordIntPair.asLong(var3, var4)) && var0.getChunkSource().getChunkNow(var3, var4) != null) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class b
    implements GameEventListener {
        private final VibrationSystem system;

        public b(VibrationSystem var0) {
            this.system = var0;
        }

        @Override
        public PositionSource getListenerSource() {
            return this.system.getVibrationUser().getPositionSource();
        }

        @Override
        public int getListenerRadius() {
            return this.system.getVibrationUser().getListenerRadius();
        }

        @Override
        public boolean handleGameEvent(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3) {
            a var4 = this.system.getVibrationData();
            d var5 = this.system.getVibrationUser();
            if (var4.getCurrentVibration() != null) {
                return false;
            }
            if (!var5.isValidVibration(var1, var2)) {
                return false;
            }
            Optional<Vec3D> var6 = var5.getPositionSource().getPosition(var0);
            if (var6.isEmpty()) {
                return false;
            }
            Vec3D var7 = var6.get();
            if (!var5.canReceiveVibration(var0, BlockPosition.containing(var3), var1, var2)) {
                return false;
            }
            if (b.isOccluded(var0, var3, var7)) {
                return false;
            }
            this.scheduleVibration(var0, var4, var1, var2, var3, var7);
            return true;
        }

        public void forceScheduleVibration(WorldServer var0, GameEvent var1, GameEvent.a var2, Vec3D var3) {
            this.system.getVibrationUser().getPositionSource().getPosition(var0).ifPresent(var4 -> this.scheduleVibration(var0, this.system.getVibrationData(), var1, var2, var3, (Vec3D)var4));
        }

        private void scheduleVibration(WorldServer var0, a var1, GameEvent var2, GameEvent.a var3, Vec3D var4, Vec3D var5) {
            var1.selectionStrategy.addCandidate(new VibrationInfo(var2, (float)var4.distanceTo(var5), var4, var3.sourceEntity()), var0.getGameTime());
        }

        public static float distanceBetweenInBlocks(BlockPosition var0, BlockPosition var1) {
            return (float)Math.sqrt(var0.distSqr(var1));
        }

        private static boolean isOccluded(World var02, Vec3D var1, Vec3D var2) {
            Vec3D var3 = new Vec3D((double)MathHelper.floor(var1.x) + 0.5, (double)MathHelper.floor(var1.y) + 0.5, (double)MathHelper.floor(var1.z) + 0.5);
            Vec3D var4 = new Vec3D((double)MathHelper.floor(var2.x) + 0.5, (double)MathHelper.floor(var2.y) + 0.5, (double)MathHelper.floor(var2.z) + 0.5);
            for (EnumDirection var8 : EnumDirection.values()) {
                Vec3D var9 = var3.relative(var8, 1.0E-5f);
                if (var02.isBlockInLine(new ClipBlockStateContext(var9, var4, var0 -> var0.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS))).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) continue;
                return false;
            }
            return true;
        }
    }

    public static final class a {
        public static Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)VibrationInfo.CODEC.optionalFieldOf("event").forGetter(var0 -> Optional.ofNullable(var0.currentVibration)), (App)VibrationSelector.CODEC.fieldOf("selector").forGetter(a::getSelectionStrategy), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("event_delay").orElse((Object)0).forGetter(a::getTravelTimeInTicks)).apply((Applicative)var02, (var0, var1, var2) -> new a(var0.orElse(null), (VibrationSelector)var1, (int)var2, true)));
        public static final String NBT_TAG_KEY = "listener";
        @Nullable
        VibrationInfo currentVibration;
        private int travelTimeInTicks;
        final VibrationSelector selectionStrategy;
        private boolean reloadVibrationParticle;

        private a(@Nullable VibrationInfo var0, VibrationSelector var1, int var2, boolean var3) {
            this.currentVibration = var0;
            this.travelTimeInTicks = var2;
            this.selectionStrategy = var1;
            this.reloadVibrationParticle = var3;
        }

        public a() {
            this(null, new VibrationSelector(), 0, false);
        }

        public VibrationSelector getSelectionStrategy() {
            return this.selectionStrategy;
        }

        @Nullable
        public VibrationInfo getCurrentVibration() {
            return this.currentVibration;
        }

        public void setCurrentVibration(@Nullable VibrationInfo var0) {
            this.currentVibration = var0;
        }

        public int getTravelTimeInTicks() {
            return this.travelTimeInTicks;
        }

        public void setTravelTimeInTicks(int var0) {
            this.travelTimeInTicks = var0;
        }

        public void decrementTravelTime() {
            this.travelTimeInTicks = Math.max(0, this.travelTimeInTicks - 1);
        }

        public boolean shouldReloadVibrationParticle() {
            return this.reloadVibrationParticle;
        }

        public void setReloadVibrationParticle(boolean var0) {
            this.reloadVibrationParticle = var0;
        }
    }
}

