/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import com.mojang.serialization.Codec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;

public interface PositionSourceType<T extends PositionSource> {
    public static final PositionSourceType<BlockPositionSource> BLOCK = PositionSourceType.register("block", new BlockPositionSource.a());
    public static final PositionSourceType<EntityPositionSource> ENTITY = PositionSourceType.register("entity", new EntityPositionSource.a());

    public T read(PacketDataSerializer var1);

    public void write(PacketDataSerializer var1, T var2);

    public Codec<T> codec();

    public static <S extends PositionSourceType<T>, T extends PositionSource> S register(String var0, S var1) {
        return (S)IRegistry.register(BuiltInRegistries.POSITION_SOURCE_TYPE, var0, var1);
    }

    public static PositionSource fromNetwork(PacketDataSerializer var0) {
        PositionSourceType<?> var1 = var0.readById(BuiltInRegistries.POSITION_SOURCE_TYPE);
        if (var1 == null) {
            throw new IllegalArgumentException("Unknown position source type");
        }
        return var1.read(var0);
    }

    public static <T extends PositionSource> void toNetwork(T var0, PacketDataSerializer var1) {
        var1.writeId(BuiltInRegistries.POSITION_SOURCE_TYPE, var0.getType());
        var0.getType().write(var1, var0);
    }
}

