/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;

public class TrialSpawnerData {
    public static final String TAG_SPAWN_DATA = "spawn_data";
    private static final String TAG_NEXT_MOB_SPAWNS_AT = "next_mob_spawns_at";
    public static MapCodec<TrialSpawnerData> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)UUIDUtil.CODEC_SET.optionalFieldOf("registered_players", (Object)Sets.newHashSet()).forGetter(var0 -> var0.detectedPlayers), (App)UUIDUtil.CODEC_SET.optionalFieldOf("current_mobs", (Object)Sets.newHashSet()).forGetter(var0 -> var0.currentMobs), (App)Codec.LONG.optionalFieldOf("cooldown_ends_at", (Object)0L).forGetter(var0 -> var0.cooldownEndsAt), (App)Codec.LONG.optionalFieldOf(TAG_NEXT_MOB_SPAWNS_AT, (Object)0L).forGetter(var0 -> var0.nextMobSpawnsAt), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("total_mobs_spawned", (Object)0).forGetter(var0 -> var0.totalMobsSpawned), (App)MobSpawnerData.CODEC.optionalFieldOf(TAG_SPAWN_DATA).forGetter(var0 -> var0.nextSpawnData), (App)MinecraftKey.CODEC.optionalFieldOf("ejecting_loot_table").forGetter(var0 -> var0.ejectingLootTable)).apply((Applicative)var02, TrialSpawnerData::new));
    protected final Set<UUID> detectedPlayers = new HashSet<UUID>();
    protected final Set<UUID> currentMobs = new HashSet<UUID>();
    protected long cooldownEndsAt;
    protected long nextMobSpawnsAt;
    protected int totalMobsSpawned;
    protected Optional<MobSpawnerData> nextSpawnData;
    protected Optional<MinecraftKey> ejectingLootTable;
    protected SimpleWeightedRandomList<MobSpawnerData> spawnPotentials;
    @Nullable
    protected Entity displayEntity;
    protected double spin;
    protected double oSpin;

    public TrialSpawnerData() {
        this(Collections.emptySet(), Collections.emptySet(), 0L, 0L, 0, Optional.empty(), Optional.empty());
    }

    public TrialSpawnerData(Set<UUID> var0, Set<UUID> var1, long var2, long var4, int var6, Optional<MobSpawnerData> var7, Optional<MinecraftKey> var8) {
        this.detectedPlayers.addAll(var0);
        this.currentMobs.addAll(var1);
        this.cooldownEndsAt = var2;
        this.nextMobSpawnsAt = var4;
        this.totalMobsSpawned = var6;
        this.nextSpawnData = var7;
        this.ejectingLootTable = var8;
    }

    public void setSpawnPotentialsFromConfig(TrialSpawnerConfig var0) {
        SimpleWeightedRandomList<MobSpawnerData> var1 = var0.spawnPotentialsDefinition();
        this.spawnPotentials = var1.isEmpty() ? SimpleWeightedRandomList.single(this.nextSpawnData.orElseGet(MobSpawnerData::new)) : var1;
    }

    public void reset() {
        this.detectedPlayers.clear();
        this.totalMobsSpawned = 0;
        this.nextMobSpawnsAt = 0L;
        this.cooldownEndsAt = 0L;
        this.currentMobs.clear();
    }

    public boolean hasMobToSpawn() {
        boolean var0 = this.nextSpawnData.isPresent() && this.nextSpawnData.get().getEntityToSpawn().contains("id", 8);
        return var0 || !this.spawnPotentials.isEmpty();
    }

    public boolean hasFinishedSpawningAllMobs(TrialSpawnerConfig var0, int var1) {
        return this.totalMobsSpawned >= var0.calculateTargetTotalMobs(var1);
    }

    public boolean haveAllCurrentMobsDied() {
        return this.currentMobs.isEmpty();
    }

    public boolean isReadyToSpawnNextMob(WorldServer var0, TrialSpawnerConfig var1, int var2) {
        return var0.getGameTime() >= this.nextMobSpawnsAt && this.currentMobs.size() < var1.calculateTargetSimultaneousMobs(var2);
    }

    public int countAdditionalPlayers(BlockPosition var0) {
        if (this.detectedPlayers.isEmpty()) {
            SystemUtils.logAndPauseIfInIde("Trial Spawner at " + var0 + " has no detected players");
        }
        return Math.max(0, this.detectedPlayers.size() - 1);
    }

    public void tryDetectPlayers(WorldServer var0, BlockPosition var1, PlayerDetector var2, int var3) {
        List<UUID> var4 = var2.detect(var0, var1, var3);
        boolean var5 = this.detectedPlayers.addAll(var4);
        if (var5) {
            this.nextMobSpawnsAt = Math.max(var0.getGameTime() + 40L, this.nextMobSpawnsAt);
            var0.levelEvent(3013, var1, this.detectedPlayers.size());
        }
    }

    public boolean isReadyToOpenShutter(WorldServer var0, TrialSpawnerConfig var1, float var2) {
        long var3 = this.cooldownEndsAt - (long)var1.targetCooldownLength();
        return (float)var0.getGameTime() >= (float)var3 + var2;
    }

    public boolean isReadyToEjectItems(WorldServer var0, TrialSpawnerConfig var1, float var2) {
        long var3 = this.cooldownEndsAt - (long)var1.targetCooldownLength();
        return (float)(var0.getGameTime() - var3) % var2 == 0.0f;
    }

    public boolean isCooldownFinished(WorldServer var0) {
        return var0.getGameTime() >= this.cooldownEndsAt;
    }

    public void setEntityId(TrialSpawner var0, RandomSource var1, EntityTypes<?> var2) {
        this.getOrCreateNextSpawnData(var0, var1).getEntityToSpawn().putString("id", BuiltInRegistries.ENTITY_TYPE.getKey(var2).toString());
    }

    protected MobSpawnerData getOrCreateNextSpawnData(TrialSpawner var0, RandomSource var1) {
        if (this.nextSpawnData.isPresent()) {
            return this.nextSpawnData.get();
        }
        this.nextSpawnData = Optional.of(this.spawnPotentials.getRandom(var1).map(WeightedEntry.b::getData).orElseGet(MobSpawnerData::new));
        var0.markUpdated();
        return this.nextSpawnData.get();
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(TrialSpawner var0, World var1, TrialSpawnerState var2) {
        NBTTagCompound var3;
        if (!var0.canSpawnInLevel(var1) || !var2.hasSpinningMob()) {
            return null;
        }
        if (this.displayEntity == null && (var3 = this.getOrCreateNextSpawnData(var0, var1.getRandom()).getEntityToSpawn()).contains("id", 8)) {
            this.displayEntity = EntityTypes.loadEntityRecursive(var3, var1, Function.identity());
        }
        return this.displayEntity;
    }

    public NBTTagCompound getUpdateTag(TrialSpawnerState var0) {
        NBTTagCompound var12 = new NBTTagCompound();
        if (var0 == TrialSpawnerState.ACTIVE) {
            var12.putLong(TAG_NEXT_MOB_SPAWNS_AT, this.nextMobSpawnsAt);
        }
        this.nextSpawnData.ifPresent(var1 -> var12.put(TAG_SPAWN_DATA, (NBTBase)MobSpawnerData.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, var1).result().orElseThrow(() -> new IllegalStateException("Invalid SpawnData"))));
        return var12;
    }

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }
}

