/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.MobSpawnerData;

public record TrialSpawnerConfig(int requiredPlayerRange, int spawnRange, float totalMobs, float simultaneousMobs, float totalMobsAddedPerPlayer, float simultaneousMobsAddedPerPlayer, int ticksBetweenSpawn, int targetCooldownLength, SimpleWeightedRandomList<MobSpawnerData> spawnPotentialsDefinition, SimpleWeightedRandomList<MinecraftKey> lootTablesToEject) {
    public static TrialSpawnerConfig DEFAULT = new TrialSpawnerConfig(14, 4, 6.0f, 2.0f, 2.0f, 1.0f, 40, 36000, SimpleWeightedRandomList.empty(), SimpleWeightedRandomList.empty());
    public static MapCodec<TrialSpawnerConfig> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)TrialSpawnerConfig.DEFAULT.requiredPlayerRange).forGetter(TrialSpawnerConfig::requiredPlayerRange), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("spawn_range", (Object)TrialSpawnerConfig.DEFAULT.spawnRange).forGetter(TrialSpawnerConfig::spawnRange), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("total_mobs", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.totalMobs)).forGetter(TrialSpawnerConfig::totalMobs), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("simultaneous_mobs", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.simultaneousMobs)).forGetter(TrialSpawnerConfig::simultaneousMobs), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("total_mobs_added_per_player", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.totalMobsAddedPerPlayer)).forGetter(TrialSpawnerConfig::totalMobsAddedPerPlayer), (App)Codec.floatRange((float)0.0f, (float)Float.MAX_VALUE).optionalFieldOf("simultaneous_mobs_added_per_player", (Object)Float.valueOf(TrialSpawnerConfig.DEFAULT.simultaneousMobsAddedPerPlayer)).forGetter(TrialSpawnerConfig::simultaneousMobsAddedPerPlayer), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("ticks_between_spawn", (Object)TrialSpawnerConfig.DEFAULT.ticksBetweenSpawn).forGetter(TrialSpawnerConfig::ticksBetweenSpawn), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)TrialSpawnerConfig.DEFAULT.targetCooldownLength).forGetter(TrialSpawnerConfig::targetCooldownLength), (App)MobSpawnerData.LIST_CODEC.optionalFieldOf("spawn_potentials", SimpleWeightedRandomList.empty()).forGetter(TrialSpawnerConfig::spawnPotentialsDefinition), (App)SimpleWeightedRandomList.wrappedCodecAllowingEmpty(MinecraftKey.CODEC).optionalFieldOf("loot_tables_to_eject", SimpleWeightedRandomList.empty()).forGetter(TrialSpawnerConfig::lootTablesToEject)).apply((Applicative)var0, TrialSpawnerConfig::new));

    public int calculateTargetTotalMobs(int var0) {
        return (int)Math.floor(this.totalMobs + this.totalMobsAddedPerPlayer * (float)var0);
    }

    public int calculateTargetSimultaneousMobs(int var0) {
        return (int)Math.floor(this.simultaneousMobs + this.simultaneousMobsAddedPerPlayer * (float)var0);
    }
}

