/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public final class TrialSpawner {
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = MathHelper.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerConfig config;
    private final TrialSpawnerData data;
    private final a stateAccessor;
    private PlayerDetector playerDetector;
    private boolean overridePeacefulAndMobSpawnRule;

    public Codec<TrialSpawner> codec() {
        return RecordCodecBuilder.create(var02 -> var02.group((App)TrialSpawnerConfig.MAP_CODEC.forGetter(TrialSpawner::getConfig), (App)TrialSpawnerData.MAP_CODEC.forGetter(TrialSpawner::getData)).apply((Applicative)var02, (var0, var1) -> new TrialSpawner((TrialSpawnerConfig)var0, (TrialSpawnerData)var1, this.stateAccessor, this.playerDetector)));
    }

    public TrialSpawner(a var0, PlayerDetector var1) {
        this(TrialSpawnerConfig.DEFAULT, new TrialSpawnerData(), var0, var1);
    }

    public TrialSpawner(TrialSpawnerConfig var0, TrialSpawnerData var1, a var2, PlayerDetector var3) {
        this.config = var0;
        this.data = var1;
        this.data.setSpawnPotentialsFromConfig(var0);
        this.stateAccessor = var2;
        this.playerDetector = var3;
    }

    public TrialSpawnerConfig getConfig() {
        return this.config;
    }

    public TrialSpawnerData getData() {
        return this.data;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public void setState(World var0, TrialSpawnerState var1) {
        this.stateAccessor.setState(var0, var1);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public boolean canSpawnInLevel(World var0) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        return var0.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(WorldServer var0, BlockPosition var1) {
        double var12;
        RandomSource var2 = var0.getRandom();
        MobSpawnerData var3 = this.data.getOrCreateNextSpawnData(this, var0.getRandom());
        NBTTagCompound var4 = var3.entityToSpawn();
        NBTTagList var5 = var4.getList("Pos", 6);
        Optional<EntityTypes<?>> var6 = EntityTypes.by(var4);
        if (var6.isEmpty()) {
            return Optional.empty();
        }
        int var72 = var5.size();
        double var8 = var72 >= 1 ? var5.getDouble(0) : (double)var1.getX() + (var2.nextDouble() - var2.nextDouble()) * (double)this.config.spawnRange() + 0.5;
        double var10 = var72 >= 2 ? var5.getDouble(1) : (double)(var1.getY() + var2.nextInt(3) - 1);
        double d2 = var12 = var72 >= 3 ? var5.getDouble(2) : (double)var1.getZ() + (var2.nextDouble() - var2.nextDouble()) * (double)this.config.spawnRange() + 0.5;
        if (!var0.noCollision(var6.get().getAABB(var8, var10, var12))) {
            return Optional.empty();
        }
        Vec3D var14 = new Vec3D(var8, var10, var12);
        if (!TrialSpawner.inLineOfSight(var0, var1.getCenter(), var14)) {
            return Optional.empty();
        }
        BlockPosition var15 = BlockPosition.containing(var14);
        if (!EntityPositionTypes.checkSpawnRules(var6.get(), var0, EnumMobSpawn.TRIAL_SPAWNER, var15, var0.getRandom())) {
            return Optional.empty();
        }
        Entity var16 = EntityTypes.loadEntityRecursive(var4, var0, var7 -> {
            var7.moveTo(var8, var10, var12, var2.nextFloat() * 360.0f, 0.0f);
            return var7;
        });
        if (var16 == null) {
            return Optional.empty();
        }
        if (var16 instanceof EntityInsentient) {
            EntityInsentient var17 = (EntityInsentient)var16;
            if (!var17.checkSpawnObstruction(var0)) {
                return Optional.empty();
            }
            if (var3.getEntityToSpawn().size() == 1 && var3.getEntityToSpawn().contains("id", 8)) {
                var17.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var17.blockPosition()), EnumMobSpawn.TRIAL_SPAWNER, null, null);
                var17.setPersistenceRequired();
            }
        }
        if (!var0.tryAddFreshEntityWithPassengers(var16)) {
            return Optional.empty();
        }
        var0.levelEvent(3011, var1, 0);
        var0.levelEvent(3012, var15, 0);
        var0.gameEvent(var16, GameEvent.ENTITY_PLACE, var15);
        return Optional.of(var16.getUUID());
    }

    public void ejectReward(WorldServer var0, BlockPosition var1, MinecraftKey var2) {
        LootParams var4;
        LootTable var3 = var0.getServer().getLootData().getLootTable(var2);
        ObjectArrayList<ItemStack> var5 = var3.getRandomItems(var4 = new LootParams.a(var0).create(LootContextParameterSets.EMPTY));
        if (!var5.isEmpty()) {
            for (ItemStack var7 : var5) {
                DispenseBehaviorItem.spawnItem(var0, var7, 2, EnumDirection.UP, Vec3D.atBottomCenterOf(var1).relative(EnumDirection.UP, 1.2));
            }
            var0.levelEvent(3014, var1, 0);
        }
    }

    public void tickClient(World var0, BlockPosition var1) {
        RandomSource var3;
        if (!this.canSpawnInLevel(var0)) {
            this.data.oSpin = this.data.spin;
            return;
        }
        TrialSpawnerState var2 = this.getState();
        var2.emitParticles(var0, var1);
        if (var2.hasSpinningMob()) {
            double var32 = Math.max(0L, this.data.nextMobSpawnsAt - var0.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + var2.spinningMobSpeed() / (var32 + 200.0)) % 360.0;
        }
        if (var2.isCapableOfSpawning() && (var3 = var0.getRandom()).nextFloat() <= 0.02f) {
            var0.playLocalSound(var1, SoundEffects.TRIAL_SPAWNER_AMBIENT, SoundCategory.BLOCKS, var3.nextFloat() * 0.25f + 0.75f, var3.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(WorldServer var0, BlockPosition var1) {
        TrialSpawnerState var3;
        TrialSpawnerState var22 = this.getState();
        if (!this.canSpawnInLevel(var0)) {
            if (var22.isCapableOfSpawning()) {
                this.data.reset();
                this.setState(var0, TrialSpawnerState.INACTIVE);
            }
            return;
        }
        if (this.data.currentMobs.removeIf(var2 -> TrialSpawner.shouldMobBeUntracked(var0, var1, var2))) {
            this.data.nextMobSpawnsAt = var0.getGameTime() + (long)this.config.ticksBetweenSpawn();
        }
        if ((var3 = var22.tickAndGetNext(var1, this, var0)) != var22) {
            this.setState(var0, var3);
        }
    }

    private static boolean shouldMobBeUntracked(WorldServer var0, BlockPosition var1, UUID var2) {
        Entity var3 = var0.getEntity(var2);
        return var3 == null || !var3.isAlive() || !var3.level().dimension().equals(var0.dimension()) || var3.blockPosition().distSqr(var1) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(World var0, Vec3D var1, Vec3D var2) {
        MovingObjectPositionBlock var3 = var0.clip(new RayTrace(var2, var1, RayTrace.BlockCollisionOption.VISUAL, RayTrace.FluidCollisionOption.NONE, VoxelShapeCollision.empty()));
        return var3.getBlockPos().equals(BlockPosition.containing(var1)) || var3.getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    public static void addSpawnParticles(World var0, BlockPosition var1, RandomSource var2) {
        for (int var3 = 0; var3 < 20; ++var3) {
            double var4 = (double)var1.getX() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var6 = (double)var1.getY() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var8 = (double)var1.getZ() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            var0.addParticle(Particles.SMOKE, var4, var6, var8, 0.0, 0.0, 0.0);
            var0.addParticle(Particles.FLAME, var4, var6, var8, 0.0, 0.0, 0.0);
        }
    }

    public static void addDetectPlayerParticles(World var0, BlockPosition var1, RandomSource var2, int var3) {
        for (int var4 = 0; var4 < 30 + Math.min(var3, 10) * 5; ++var4) {
            double var5 = (double)(2.0f * var2.nextFloat() - 1.0f) * 0.65;
            double var7 = (double)(2.0f * var2.nextFloat() - 1.0f) * 0.65;
            double var9 = (double)var1.getX() + 0.5 + var5;
            double var11 = (double)var1.getY() + 0.1 + (double)var2.nextFloat() * 0.8;
            double var13 = (double)var1.getZ() + 0.5 + var7;
            var0.addParticle(Particles.TRIAL_SPAWNER_DETECTION, var9, var11, var13, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(World var0, BlockPosition var1, RandomSource var2) {
        for (int var3 = 0; var3 < 20; ++var3) {
            double var4 = (double)var1.getX() + 0.4 + var2.nextDouble() * 0.2;
            double var6 = (double)var1.getY() + 0.4 + var2.nextDouble() * 0.2;
            double var8 = (double)var1.getZ() + 0.4 + var2.nextDouble() * 0.2;
            double var10 = var2.nextGaussian() * 0.02;
            double var12 = var2.nextGaussian() * 0.02;
            double var14 = var2.nextGaussian() * 0.02;
            var0.addParticle(Particles.SMALL_FLAME, var4, var6, var8, var10, var12, var14 * 0.25);
            var0.addParticle(Particles.SMOKE, var4, var6, var8, var10, var12, var14);
        }
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector var0) {
        this.playerDetector = var0;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static interface a {
        public void setState(World var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }
}

