/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.Spawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import org.slf4j.Logger;

public class TrialSpawnerBlockEntity
extends TileEntity
implements Spawner,
TrialSpawner.a {
    private static final Logger LOGGER = LogUtils.getLogger();
    private TrialSpawner trialSpawner;

    public TrialSpawnerBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.TRIAL_SPAWNER, var0, var1);
        PlayerDetector var2 = PlayerDetector.PLAYERS;
        this.trialSpawner = new TrialSpawner(this, var2);
    }

    @Override
    public void load(NBTTagCompound var02) {
        super.load(var02);
        this.trialSpawner.codec().parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
            this.trialSpawner = var0;
        });
        if (this.level != null) {
            this.markUpdated();
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var02) {
        super.saveAdditional(var02);
        this.trialSpawner.codec().encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.trialSpawner).get().ifLeft(var1 -> var02.merge((NBTTagCompound)var1)).ifRight(var0 -> LOGGER.warn("Failed to encode TrialSpawner {}", (Object)var0.message()));
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.trialSpawner.getData().getUpdateTag(this.getBlockState().getValue(TrialSpawnerBlock.STATE));
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    @Override
    public void setEntityId(EntityTypes<?> var0, RandomSource var1) {
        this.trialSpawner.getData().setEntityId(this.trialSpawner, var1, var0);
        this.setChanged();
    }

    public TrialSpawner getTrialSpawner() {
        return this.trialSpawner;
    }

    @Override
    public TrialSpawnerState getState() {
        if (!this.getBlockState().hasProperty(BlockProperties.TRIAL_SPAWNER_STATE)) {
            return TrialSpawnerState.INACTIVE;
        }
        return this.getBlockState().getValue(BlockProperties.TRIAL_SPAWNER_STATE);
    }

    @Override
    public void setState(World var0, TrialSpawnerState var1) {
        this.setChanged();
        var0.setBlockAndUpdate(this.worldPosition, (IBlockData)this.getBlockState().setValue(BlockProperties.TRIAL_SPAWNER_STATE, var1));
    }

    @Override
    public void markUpdated() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

