/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntitySkull
extends TileEntity {
    public static final String TAG_SKULL_OWNER = "SkullOwner";
    public static final String TAG_NOTE_BLOCK_SOUND = "note_block_sound";
    @Nullable
    private static Executor mainThreadExecutor;
    @Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> profileCache;
    private static final Executor CHECKED_MAIN_THREAD_EXECUTOR;
    @Nullable
    public GameProfile owner;
    @Nullable
    public MinecraftKey noteBlockSound;
    private int animationTickCount;
    private boolean isAnimating;

    public TileEntitySkull(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.SKULL, var0, var1);
    }

    public static void setup(final Services var0, Executor var1) {
        mainThreadExecutor = var1;
        final BooleanSupplier var2 = () -> profileCache == null;
        profileCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(String var02) {
                if (var2.getAsBoolean()) {
                    return CompletableFuture.completedFuture(Optional.empty());
                }
                return TileEntitySkull.loadProfile(var02, var0, var2);
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((String)object);
            }
        });
    }

    public static void clear() {
        mainThreadExecutor = null;
        profileCache = null;
    }

    static CompletableFuture<Optional<GameProfile>> loadProfile(String var0, Services var1, BooleanSupplier var22) {
        return var1.profileCache().getAsync(var0).thenApplyAsync(var2 -> {
            if (var2.isPresent() && !var22.getAsBoolean()) {
                UUID var3 = ((GameProfile)var2.get()).getId();
                ProfileResult var4 = var1.sessionService().fetchProfile(var3, true);
                if (var4 != null) {
                    return Optional.ofNullable(var4.profile());
                }
                return var2;
            }
            return Optional.empty();
        }, (Executor)SystemUtils.backgroundExecutor());
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        if (this.owner != null) {
            NBTTagCompound var1 = new NBTTagCompound();
            GameProfileSerializer.writeGameProfile(var1, this.owner);
            var0.put(TAG_SKULL_OWNER, var1);
        }
        if (this.noteBlockSound != null) {
            var0.putString(TAG_NOTE_BLOCK_SOUND, this.noteBlockSound.toString());
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        String var1;
        super.load(var0);
        if (var0.contains(TAG_SKULL_OWNER, 10)) {
            this.setOwner(GameProfileSerializer.readGameProfile(var0.getCompound(TAG_SKULL_OWNER)));
        } else if (var0.contains("ExtraType", 8) && !UtilColor.isNullOrEmpty(var1 = var0.getString("ExtraType"))) {
            this.setOwner(new GameProfile(SystemUtils.NIL_UUID, var1));
        }
        if (var0.contains(TAG_NOTE_BLOCK_SOUND, 8)) {
            this.noteBlockSound = MinecraftKey.tryParse(var0.getString(TAG_NOTE_BLOCK_SOUND));
        }
    }

    public static void animation(World var0, BlockPosition var1, IBlockData var2, TileEntitySkull var3) {
        if (var2.hasProperty(BlockSkull.POWERED) && var2.getValue(BlockSkull.POWERED).booleanValue()) {
            var3.isAnimating = true;
            ++var3.animationTickCount;
        } else {
            var3.isAnimating = false;
        }
    }

    public float getAnimation(float var0) {
        if (this.isAnimating) {
            return (float)this.animationTickCount + var0;
        }
        return this.animationTickCount;
    }

    @Nullable
    public GameProfile getOwnerProfile() {
        return this.owner;
    }

    @Nullable
    public MinecraftKey getNoteBlockSound() {
        return this.noteBlockSound;
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile var0) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.owner = var0;
        }
        this.updateOwnerProfile();
    }

    private void updateOwnerProfile() {
        if (this.owner == null || SystemUtils.isBlank(this.owner.getName()) || TileEntitySkull.hasTextures(this.owner)) {
            this.setChanged();
            return;
        }
        TileEntitySkull.fetchGameProfile(this.owner.getName()).thenAcceptAsync(var0 -> {
            this.owner = var0.orElse(this.owner);
            this.setChanged();
        }, CHECKED_MAIN_THREAD_EXECUTOR);
    }

    @Nullable
    public static GameProfile getOrResolveGameProfile(NBTTagCompound var0) {
        String var1;
        if (var0.contains(TAG_SKULL_OWNER, 10)) {
            return GameProfileSerializer.readGameProfile(var0.getCompound(TAG_SKULL_OWNER));
        }
        if (var0.contains(TAG_SKULL_OWNER, 8) && !SystemUtils.isBlank(var1 = var0.getString(TAG_SKULL_OWNER))) {
            var0.remove(TAG_SKULL_OWNER);
            TileEntitySkull.resolveGameProfile(var0, var1);
        }
        return null;
    }

    public static void resolveGameProfile(NBTTagCompound var0) {
        String var1 = var0.getString(TAG_SKULL_OWNER);
        if (!SystemUtils.isBlank(var1)) {
            TileEntitySkull.resolveGameProfile(var0, var1);
        }
    }

    private static void resolveGameProfile(NBTTagCompound var0, String var1) {
        TileEntitySkull.fetchGameProfile(var1).thenAccept(var2 -> var0.put(TAG_SKULL_OWNER, GameProfileSerializer.writeGameProfile(new NBTTagCompound(), var2.orElse(new GameProfile(SystemUtils.NIL_UUID, var1)))));
    }

    private static CompletableFuture<Optional<GameProfile>> fetchGameProfile(String var0) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> var1 = profileCache;
        if (var1 != null && EntityHuman.isValidUsername(var0)) {
            return (CompletableFuture)var1.getUnchecked((Object)var0);
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    private static boolean hasTextures(GameProfile var0) {
        return var0.getProperties().containsKey((Object)"textures");
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    static {
        CHECKED_MAIN_THREAD_EXECUTOR = var0 -> {
            Executor var1 = mainThreadExecutor;
            if (var1 != null) {
                var1.execute(var0);
            }
        };
    }
}

