/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class TileEntitySign
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_TEXT_LINE_WIDTH = 90;
    private static final int TEXT_LINE_HEIGHT = 10;
    @Nullable
    public UUID playerWhoMayEdit;
    private SignText frontText = this.createDefaultSignText();
    private SignText backText = this.createDefaultSignText();
    private boolean isWaxed;

    public TileEntitySign(BlockPosition var0, IBlockData var1) {
        this((TileEntityTypes)TileEntityTypes.SIGN, var0, var1);
    }

    public TileEntitySign(TileEntityTypes var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    protected SignText createDefaultSignText() {
        return new SignText();
    }

    public boolean isFacingFrontText(EntityHuman var0) {
        Block block = this.getBlockState().getBlock();
        if (block instanceof BlockSign) {
            float var8;
            BlockSign var1 = (BlockSign)block;
            Vec3D var2 = var1.getSignHitboxCenterPosition(this.getBlockState());
            double var3 = var0.getX() - ((double)this.getBlockPos().getX() + var2.x);
            double var5 = var0.getZ() - ((double)this.getBlockPos().getZ() + var2.z);
            float var7 = var1.getYRotationDegrees(this.getBlockState());
            return MathHelper.degreesDifferenceAbs(var7, var8 = (float)(MathHelper.atan2(var5, var3) * 57.2957763671875) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText getText(boolean var0) {
        return var0 ? this.frontText : this.backText;
    }

    public SignText getFrontText() {
        return this.frontText;
    }

    public SignText getBackText() {
        return this.backText;
    }

    public int getTextLineHeight() {
        return 10;
    }

    public int getMaxTextLineWidth() {
        return 90;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        SignText.DIRECT_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.frontText).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("front_text", (NBTBase)var1));
        SignText.DIRECT_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.backText).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var1 -> var0.put("back_text", (NBTBase)var1));
        var0.putBoolean("is_waxed", this.isWaxed);
    }

    @Override
    public void load(NBTTagCompound var02) {
        super.load(var02);
        if (var02.contains("front_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("front_text")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.frontText = this.loadLines((SignText)var0);
            });
        }
        if (var02.contains("back_text")) {
            SignText.DIRECT_CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.getCompound("back_text")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(var0 -> {
                this.backText = this.loadLines((SignText)var0);
            });
        }
        this.isWaxed = var02.getBoolean("is_waxed");
    }

    private SignText loadLines(SignText var0) {
        for (int var1 = 0; var1 < 4; ++var1) {
            IChatBaseComponent var2 = this.loadLine(var0.getMessage(var1, false));
            IChatBaseComponent var3 = this.loadLine(var0.getMessage(var1, true));
            var0 = var0.setMessage(var1, var2, var3);
        }
        return var0;
    }

    private IChatBaseComponent loadLine(IChatBaseComponent var0) {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            try {
                return ChatComponentUtils.updateForEntity(TileEntitySign.createCommandSourceStack(null, var1, this.worldPosition), var0, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return var0;
    }

    public void updateSignText(EntityHuman var0, boolean var1, List<FilteredText> var22) {
        if (this.isWaxed() || !var0.getUUID().equals(this.getPlayerWhoMayEdit()) || this.level == null) {
            LOGGER.warn("Player {} just tried to change non-editable sign", (Object)var0.getName().getString());
            return;
        }
        this.updateText(var2 -> this.setMessages(var0, var22, (SignText)var2), var1);
        this.setAllowedPlayerEditor(null);
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public boolean updateText(UnaryOperator<SignText> var0, boolean var1) {
        SignText var2 = this.getText(var1);
        return this.setText((SignText)var0.apply(var2), var1);
    }

    private SignText setMessages(EntityHuman var0, List<FilteredText> var1, SignText var2) {
        for (int var3 = 0; var3 < var1.size(); ++var3) {
            FilteredText var4 = var1.get(var3);
            ChatModifier var5 = var2.getMessage(var3, var0.isTextFilteringEnabled()).getStyle();
            var2 = var0.isTextFilteringEnabled() ? var2.setMessage(var3, IChatBaseComponent.literal(var4.filteredOrEmpty()).setStyle(var5)) : var2.setMessage(var3, IChatBaseComponent.literal(var4.raw()).setStyle(var5), IChatBaseComponent.literal(var4.filteredOrEmpty()).setStyle(var5));
        }
        return var2;
    }

    public boolean setText(SignText var0, boolean var1) {
        return var1 ? this.setFrontText(var0) : this.setBackText(var0);
    }

    private boolean setBackText(SignText var0) {
        if (var0 != this.backText) {
            this.backText = var0;
            this.markUpdated();
            return true;
        }
        return false;
    }

    private boolean setFrontText(SignText var0) {
        if (var0 != this.frontText) {
            this.frontText = var0;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean canExecuteClickCommands(boolean var0, EntityHuman var1) {
        return this.isWaxed() && this.getText(var0).hasAnyClickCommands(var1);
    }

    public boolean executeClickCommandsIfPresent(EntityHuman var0, World var1, BlockPosition var2, boolean var3) {
        boolean var4 = false;
        for (IChatBaseComponent var8 : this.getText(var3).getMessages(var0.isTextFilteringEnabled())) {
            ChatModifier var9 = var8.getStyle();
            ChatClickable var10 = var9.getClickEvent();
            if (var10 == null || var10.getAction() != ChatClickable.EnumClickAction.RUN_COMMAND) continue;
            var0.getServer().getCommands().performPrefixedCommand(TileEntitySign.createCommandSourceStack(var0, var1, var2), var10.getValue());
            var4 = true;
        }
        return var4;
    }

    private static CommandListenerWrapper createCommandSourceStack(@Nullable EntityHuman var0, World var1, BlockPosition var2) {
        String var3 = var0 == null ? "Sign" : var0.getName().getString();
        IChatBaseComponent var4 = var0 == null ? IChatBaseComponent.literal("Sign") : var0.getDisplayName();
        return new CommandListenerWrapper(ICommandListener.NULL, Vec3D.atCenterOf(var2), Vec2F.ZERO, (WorldServer)var1, 2, var3, var4, var1.getServer(), var0);
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    @Override
    public boolean onlyOpCanSetNbt() {
        return true;
    }

    public void setAllowedPlayerEditor(@Nullable UUID var0) {
        this.playerWhoMayEdit = var0;
    }

    @Nullable
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    private void markUpdated() {
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
    }

    public boolean isWaxed() {
        return this.isWaxed;
    }

    public boolean setWaxed(boolean var0) {
        if (this.isWaxed != var0) {
            this.isWaxed = var0;
            this.markUpdated();
            return true;
        }
        return false;
    }

    public boolean playerIsTooFarAwayToEdit(UUID var0) {
        EntityHuman var1 = this.level.getPlayerByUUID(var0);
        return var1 == null || var1.distanceToSqr(this.getBlockPos().getX(), this.getBlockPos().getY(), this.getBlockPos().getZ()) > 64.0;
    }

    public static void tick(World var0, BlockPosition var1, IBlockData var2, TileEntitySign var3) {
        UUID var4 = var3.getPlayerWhoMayEdit();
        if (var4 != null) {
            var3.clearInvalidPlayerWhoMayEdit(var3, var0, var4);
        }
    }

    private void clearInvalidPlayerWhoMayEdit(TileEntitySign var0, World var1, UUID var2) {
        if (var0.playerIsTooFarAwayToEdit(var2)) {
            var0.setAllowedPlayerEditor(null);
        }
    }

    public SoundEffect getSignInteractionFailedSoundEvent() {
        return SoundEffects.WAXED_SIGN_INTERACT_FAIL;
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

