/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class TileEntityLootable
extends TileEntityContainer
implements RandomizableContainer {
    @Nullable
    public MinecraftKey lootTable;
    public long lootTableSeed;

    protected TileEntityLootable(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    @Override
    @Nullable
    public MinecraftKey getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable MinecraftKey var0) {
        this.lootTable = var0;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long var0) {
        this.lootTableSeed = var0;
    }

    @Override
    public boolean isEmpty() {
        this.unpackLootTable(null);
        return this.getItems().stream().allMatch(ItemStack::isEmpty);
    }

    @Override
    public ItemStack getItem(int var0) {
        this.unpackLootTable(null);
        return this.getItems().get(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        this.unpackLootTable(null);
        ItemStack var2 = ContainerUtil.removeItem(this.getItems(), var0, var1);
        if (!var2.isEmpty()) {
            this.setChanged();
        }
        return var2;
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        this.unpackLootTable(null);
        return ContainerUtil.takeItem(this.getItems(), var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.unpackLootTable(null);
        this.getItems().set(var0, var1);
        if (var1.getCount() > this.getMaxStackSize()) {
            var1.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return IInventory.stillValidBlockEntity(this, var0);
    }

    @Override
    public void clearContent() {
        this.getItems().clear();
    }

    protected abstract NonNullList<ItemStack> getItems();

    protected abstract void setItems(NonNullList<ItemStack> var1);

    @Override
    public boolean canOpen(EntityHuman var0) {
        return super.canOpen(var0) && (this.lootTable == null || !var0.isSpectator());
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.canOpen(var2)) {
            this.unpackLootTable(var1.player);
            return this.createMenu(var0, var1);
        }
        return null;
    }
}

