/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ChestLock;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public abstract class TileEntityContainer
extends TileEntity
implements IInventory,
ITileInventory,
INamableTileEntity {
    public ChestLock lockKey = ChestLock.NO_LOCK;
    @Nullable
    public IChatBaseComponent name;

    protected TileEntityContainer(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.lockKey = ChestLock.fromTag(var0);
        if (var0.contains("CustomName", 8)) {
            this.name = IChatBaseComponent.ChatSerializer.fromJson(var0.getString("CustomName"));
        }
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        this.lockKey.addToTag(var0);
        if (this.name != null) {
            var0.putString("CustomName", IChatBaseComponent.ChatSerializer.toJson(this.name));
        }
    }

    public void setCustomName(IChatBaseComponent var0) {
        this.name = var0;
    }

    @Override
    public IChatBaseComponent getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.getDefaultName();
    }

    @Override
    public IChatBaseComponent getDisplayName() {
        return this.getName();
    }

    @Override
    @Nullable
    public IChatBaseComponent getCustomName() {
        return this.name;
    }

    protected abstract IChatBaseComponent getDefaultName();

    public boolean canOpen(EntityHuman var0) {
        return TileEntityContainer.canUnlock(var0, this.lockKey, this.getDisplayName());
    }

    public static boolean canUnlock(EntityHuman var0, ChestLock var1, IChatBaseComponent var2) {
        if (var0.isSpectator() || var1.unlocksWith(var0.getMainHandItem())) {
            return true;
        }
        var0.displayClientMessage(IChatBaseComponent.translatable("container.isLocked", var2), true);
        var0.playNotifySound(SoundEffects.CHEST_LOCKED, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return false;
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.canOpen(var2)) {
            return this.createMenu(var0, var1);
        }
        return null;
    }

    protected abstract Container createMenu(int var1, PlayerInventory var2);
}

