/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.ticks.ContainerSingleItem;

public class DecoratedPotBlockEntity
extends TileEntity
implements RandomizableContainer,
ContainerSingleItem {
    public static final String TAG_SHERDS = "sherds";
    public static final String TAG_ITEM = "item";
    public static final int EVENT_POT_WOBBLES = 1;
    public long wobbleStartedAtTick;
    @Nullable
    public b lastWobbleStyle;
    public Decoration decorations;
    private ItemStack item = ItemStack.EMPTY;
    @Nullable
    protected MinecraftKey lootTable;
    protected long lootTableSeed;

    public DecoratedPotBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.DECORATED_POT, var0, var1);
        this.decorations = Decoration.EMPTY;
    }

    @Override
    protected void saveAdditional(NBTTagCompound var0) {
        super.saveAdditional(var0);
        this.decorations.save(var0);
        if (!this.trySaveLootTable(var0) && !this.item.isEmpty()) {
            var0.put(TAG_ITEM, this.item.save(new NBTTagCompound()));
        }
    }

    @Override
    public void load(NBTTagCompound var0) {
        super.load(var0);
        this.decorations = Decoration.load(var0);
        if (!this.tryLoadLootTable(var0)) {
            this.item = var0.contains(TAG_ITEM, 10) ? ItemStack.of(var0.getCompound(TAG_ITEM)) : ItemStack.EMPTY;
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag() {
        return this.saveWithoutMetadata();
    }

    public EnumDirection getDirection() {
        return this.getBlockState().getValue(BlockProperties.HORIZONTAL_FACING);
    }

    public Decoration getDecorations() {
        return this.decorations;
    }

    public void setFromItem(ItemStack var0) {
        this.decorations = Decoration.load(ItemBlock.getBlockEntityData(var0));
    }

    public ItemStack getPotAsItem() {
        return DecoratedPotBlockEntity.createDecoratedPotItem(this.decorations);
    }

    public static ItemStack createDecoratedPotItem(Decoration var0) {
        ItemStack var1 = Items.DECORATED_POT.getDefaultInstance();
        NBTTagCompound var2 = var0.save(new NBTTagCompound());
        ItemBlock.setBlockEntityData(var1, TileEntityTypes.DECORATED_POT, var2);
        return var1;
    }

    @Override
    @Nullable
    public MinecraftKey getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable MinecraftKey var0) {
        this.lootTable = var0;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long var0) {
        this.lootTableSeed = var0;
    }

    @Override
    public ItemStack getTheItem() {
        this.unpackLootTable(null);
        return this.item;
    }

    @Override
    public ItemStack splitTheItem(int var0) {
        this.unpackLootTable(null);
        ItemStack var1 = this.item.split(var0);
        if (this.item.isEmpty()) {
            this.item = ItemStack.EMPTY;
        }
        return var1;
    }

    @Override
    public void setTheItem(ItemStack var0) {
        this.unpackLootTable(null);
        this.item = var0;
    }

    @Override
    public TileEntity getContainerBlockEntity() {
        return this;
    }

    public void wobble(b var0) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 1, var0.ordinal());
    }

    @Override
    public boolean triggerEvent(int var0, int var1) {
        if (this.level != null && var0 == 1 && var1 >= 0 && var1 < b.values().length) {
            this.wobbleStartedAtTick = this.level.getGameTime();
            this.lastWobbleStyle = b.values()[var1];
            return true;
        }
        return super.triggerEvent(var0, var1);
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public record Decoration(Item back, Item left, Item right, Item front) {
        public static final Decoration EMPTY = new Decoration(Items.BRICK, Items.BRICK, Items.BRICK, Items.BRICK);

        public NBTTagCompound save(NBTTagCompound var0) {
            if (this.equals(EMPTY)) {
                return var0;
            }
            NBTTagList var12 = new NBTTagList();
            this.sorted().forEach(var1 -> var12.add(NBTTagString.valueOf(BuiltInRegistries.ITEM.getKey((Item)var1).toString())));
            var0.put(DecoratedPotBlockEntity.TAG_SHERDS, var12);
            return var0;
        }

        public Stream<Item> sorted() {
            return Stream.of(this.back, this.left, this.right, this.front);
        }

        public static Decoration load(@Nullable NBTTagCompound var0) {
            if (var0 == null || !var0.contains(DecoratedPotBlockEntity.TAG_SHERDS, 9)) {
                return EMPTY;
            }
            NBTTagList var1 = var0.getList(DecoratedPotBlockEntity.TAG_SHERDS, 8);
            return new Decoration(Decoration.itemFromTag(var1, 0), Decoration.itemFromTag(var1, 1), Decoration.itemFromTag(var1, 2), Decoration.itemFromTag(var1, 3));
        }

        private static Item itemFromTag(NBTTagList var0, int var1) {
            if (var1 >= var0.size()) {
                return Items.BRICK;
            }
            NBTBase var2 = var0.get(var1);
            return BuiltInRegistries.ITEM.get(MinecraftKey.tryParse(var2.getAsString()));
        }
    }

    public static final class b
    extends Enum<b> {
        public static final /* enum */ b POSITIVE = new b(7);
        public static final /* enum */ b NEGATIVE = new b(10);
        public final int duration;
        private static final /* synthetic */ b[] d;

        public static b[] values() {
            return (b[])d.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(int var2) {
            this.duration = var2;
        }

        private static /* synthetic */ b[] a() {
            return new b[]{POSITIVE, NEGATIVE};
        }

        static {
            d = b.a();
        }
    }
}

