/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockSetType;

public class WeatheringCopperDoorBlock
extends BlockDoor
implements WeatheringCopper {
    public static final MapCodec<WeatheringCopperDoorBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(BlockDoor::type), (App)WeatheringCopper.a.CODEC.fieldOf("weathering_state").forGetter(WeatheringCopperDoorBlock::getAge), WeatheringCopperDoorBlock.propertiesCodec()).apply((Applicative)var0, WeatheringCopperDoorBlock::new));
    private final WeatheringCopper.a weatherState;

    public MapCodec<WeatheringCopperDoorBlock> codec() {
        return CODEC;
    }

    protected WeatheringCopperDoorBlock(BlockSetType var0, WeatheringCopper.a var1, BlockBase.Info var2) {
        super(var0, var2);
        this.weatherState = var1;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var0.getValue(BlockDoor.HALF) == BlockPropertyDoubleBlockHalf.LOWER) {
            this.changeOverTime(var0, var1, var2, var3);
        }
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return WeatheringCopper.getNext(var0.getBlock()).isPresent();
    }

    @Override
    public WeatheringCopper.a getAge() {
        return this.weatherState;
    }

    @Override
    public /* synthetic */ Enum getAge() {
        return this.getAge();
    }
}

