/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class SnifferEggBlock
extends Block {
    public static final MapCodec<SnifferEggBlock> CODEC = SnifferEggBlock.simpleCodec(SnifferEggBlock::new);
    public static final int MAX_HATCH_LEVEL = 2;
    public static final BlockStateInteger HATCH = BlockProperties.HATCH;
    private static final int REGULAR_HATCH_TIME_TICKS = 24000;
    private static final int BOOSTED_HATCH_TIME_TICKS = 12000;
    private static final int RANDOM_HATCH_OFFSET_TICKS = 300;
    private static final VoxelShape SHAPE = Block.box(1.0, 0.0, 2.0, 15.0, 16.0, 14.0);

    public MapCodec<SnifferEggBlock> codec() {
        return CODEC;
    }

    public SnifferEggBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HATCH, 0));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HATCH);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    public int getHatchLevel(IBlockData var0) {
        return var0.getValue(HATCH);
    }

    private boolean isReadyToHatch(IBlockData var0) {
        return this.getHatchLevel(var0) == 2;
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!this.isReadyToHatch(var0)) {
            var1.playSound(null, var2, SoundEffects.SNIFFER_EGG_CRACK, SoundCategory.BLOCKS, 0.7f, 0.9f + var3.nextFloat() * 0.2f);
            var1.setBlock(var2, (IBlockData)var0.setValue(HATCH, this.getHatchLevel(var0) + 1), 2);
            return;
        }
        var1.playSound(null, var2, SoundEffects.SNIFFER_EGG_HATCH, SoundCategory.BLOCKS, 0.7f, 0.9f + var3.nextFloat() * 0.2f);
        var1.destroyBlock(var2, false);
        Sniffer var4 = EntityTypes.SNIFFER.create(var1);
        if (var4 != null) {
            Vec3D var5 = var2.getCenter();
            var4.setBaby(true);
            var4.moveTo(var5.x(), var5.y(), var5.z(), MathHelper.wrapDegrees(var1.random.nextFloat() * 360.0f), 0.0f);
            var1.addFreshEntity(var4);
        }
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        boolean var5 = SnifferEggBlock.hatchBoost(var1, var2);
        if (!var1.isClientSide() && var5) {
            var1.levelEvent(3009, var2, 0);
        }
        int var6 = var5 ? 12000 : 24000;
        int var7 = var6 / 3;
        var1.gameEvent(GameEvent.BLOCK_PLACE, var2, GameEvent.a.of(var0));
        var1.scheduleTick(var2, this, var7 + var1.random.nextInt(300));
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    public static boolean hatchBoost(IBlockAccess var0, BlockPosition var1) {
        return var0.getBlockState(var1.below()).is(TagsBlock.SNIFFER_EGG_HATCH_BOOST);
    }
}

