/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockStepAbstract;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.IBlockDataHolder;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertyStairsShape;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class BlockStairs
extends Block
implements IBlockWaterlogged {
    public static final MapCodec<BlockStairs> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)IBlockData.CODEC.fieldOf("base_state").forGetter(var0 -> var0.baseState), BlockStairs.propertiesCodec()).apply((Applicative)var02, BlockStairs::new));
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateEnum<BlockPropertyHalf> HALF = BlockProperties.HALF;
    public static final BlockStateEnum<BlockPropertyStairsShape> SHAPE = BlockProperties.STAIRS_SHAPE;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    protected static final VoxelShape TOP_AABB = BlockStepAbstract.TOP_AABB;
    protected static final VoxelShape BOTTOM_AABB = BlockStepAbstract.BOTTOM_AABB;
    protected static final VoxelShape OCTET_NNN = Block.box(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape OCTET_NNP = Block.box(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape OCTET_NPN = Block.box(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape OCTET_NPP = Block.box(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape OCTET_PNN = Block.box(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape OCTET_PNP = Block.box(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape OCTET_PPN = Block.box(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape OCTET_PPP = Block.box(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] TOP_SHAPES = BlockStairs.makeShapes(TOP_AABB, OCTET_NNN, OCTET_PNN, OCTET_NNP, OCTET_PNP);
    protected static final VoxelShape[] BOTTOM_SHAPES = BlockStairs.makeShapes(BOTTOM_AABB, OCTET_NPN, OCTET_PPN, OCTET_NPP, OCTET_PPP);
    private static final int[] SHAPE_BY_STATE = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block base;
    protected final IBlockData baseState;

    public MapCodec<? extends BlockStairs> codec() {
        return CODEC;
    }

    private static VoxelShape[] makeShapes(VoxelShape var0, VoxelShape var1, VoxelShape var2, VoxelShape var3, VoxelShape var4) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(var5 -> BlockStairs.makeStairShape(var5, var0, var1, var2, var3, var4)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape makeStairShape(int var0, VoxelShape var1, VoxelShape var2, VoxelShape var3, VoxelShape var4, VoxelShape var5) {
        VoxelShape var6 = var1;
        if ((var0 & 1) != 0) {
            var6 = VoxelShapes.or(var6, var2);
        }
        if ((var0 & 2) != 0) {
            var6 = VoxelShapes.or(var6, var3);
        }
        if ((var0 & 4) != 0) {
            var6 = VoxelShapes.or(var6, var4);
        }
        if ((var0 & 8) != 0) {
            var6 = VoxelShapes.or(var6, var5);
        }
        return var6;
    }

    protected BlockStairs(IBlockData var0, BlockBase.Info var1) {
        super(var1);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(HALF, BlockPropertyHalf.BOTTOM)).setValue(SHAPE, BlockPropertyStairsShape.STRAIGHT)).setValue(WATERLOGGED, false));
        this.base = var0.getBlock();
        this.baseState = var0;
    }

    @Override
    public boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return (var0.getValue(HALF) == BlockPropertyHalf.TOP ? TOP_SHAPES : BOTTOM_SHAPES)[SHAPE_BY_STATE[this.getShapeIndex(var0)]];
    }

    private int getShapeIndex(IBlockData var0) {
        return var0.getValue(SHAPE).ordinal() * 4 + var0.getValue(FACING).get2DDataValue();
    }

    @Override
    public float getExplosionResistance() {
        return this.base.getExplosionResistance();
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection var1 = var0.getClickedFace();
        BlockPosition var2 = var0.getClickedPos();
        Fluid var3 = var0.getLevel().getFluidState(var2);
        IBlockData var4 = (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection())).setValue(HALF, var1 == EnumDirection.DOWN || var1 != EnumDirection.UP && var0.getClickLocation().y - (double)var2.getY() > 0.5 ? BlockPropertyHalf.TOP : BlockPropertyHalf.BOTTOM)).setValue(WATERLOGGED, var3.getType() == FluidTypes.WATER);
        return (IBlockData)var4.setValue(SHAPE, BlockStairs.getStairsShape(var4, var0.getLevel(), var2));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var3.scheduleTick(var4, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var3));
        }
        if (var1.getAxis().isHorizontal()) {
            return (IBlockData)var0.setValue(SHAPE, BlockStairs.getStairsShape(var0, var3, var4));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    private static BlockPropertyStairsShape getStairsShape(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        EnumDirection var6;
        Object var5;
        EnumDirection var3 = var0.getValue(FACING);
        IBlockData var4 = var1.getBlockState(var2.relative(var3));
        if (BlockStairs.isStairs(var4) && var0.getValue(HALF) == var4.getValue(HALF) && ((EnumDirection)(var5 = var4.getValue(FACING))).getAxis() != var0.getValue(FACING).getAxis() && BlockStairs.canTakeShape(var0, var1, var2, ((EnumDirection)var5).getOpposite())) {
            if (var5 == var3.getCounterClockWise()) {
                return BlockPropertyStairsShape.OUTER_LEFT;
            }
            return BlockPropertyStairsShape.OUTER_RIGHT;
        }
        var5 = var1.getBlockState(var2.relative(var3.getOpposite()));
        if (BlockStairs.isStairs((IBlockData)var5) && var0.getValue(HALF) == ((IBlockDataHolder)var5).getValue(HALF) && (var6 = ((IBlockDataHolder)var5).getValue(FACING)).getAxis() != var0.getValue(FACING).getAxis() && BlockStairs.canTakeShape(var0, var1, var2, var6)) {
            if (var6 == var3.getCounterClockWise()) {
                return BlockPropertyStairsShape.INNER_LEFT;
            }
            return BlockPropertyStairsShape.INNER_RIGHT;
        }
        return BlockPropertyStairsShape.STRAIGHT;
    }

    private static boolean canTakeShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        IBlockData var4 = var1.getBlockState(var2.relative(var3));
        return !BlockStairs.isStairs(var4) || var4.getValue(FACING) != var0.getValue(FACING) || var4.getValue(HALF) != var0.getValue(HALF);
    }

    public static boolean isStairs(IBlockData var0) {
        return var0.getBlock() instanceof BlockStairs;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        EnumDirection var2 = var0.getValue(FACING);
        BlockPropertyStairsShape var3 = var0.getValue(SHAPE);
        switch (var1) {
            case LEFT_RIGHT: {
                if (var2.getAxis() != EnumDirection.EnumAxis.Z) break;
                switch (var3) {
                    case INNER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_LEFT);
                    }
                }
                return var0.rotate(EnumBlockRotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (var2.getAxis() != EnumDirection.EnumAxis.X) break;
                switch (var3) {
                    case INNER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockData)var0.rotate(EnumBlockRotation.CLOCKWISE_180).setValue(SHAPE, BlockPropertyStairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return var0.rotate(EnumBlockRotation.CLOCKWISE_180);
                    }
                }
                break;
            }
        }
        return super.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, HALF, SHAPE, WATERLOGGED);
    }

    @Override
    public Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }
}

