/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;

public class BlockSkullPlayer
extends BlockSkull {
    public static final MapCodec<BlockSkullPlayer> CODEC = BlockSkullPlayer.simpleCodec(BlockSkullPlayer::new);

    public MapCodec<BlockSkullPlayer> codec() {
        return CODEC;
    }

    protected BlockSkullPlayer(BlockBase.Info var0) {
        super(BlockSkull.Type.PLAYER, var0);
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        TileEntity var5 = var0.getBlockEntity(var1);
        if (var5 instanceof TileEntitySkull) {
            TileEntitySkull var6 = (TileEntitySkull)var5;
            GameProfile var7 = null;
            if (var4.hasTag()) {
                NBTTagCompound var8 = var4.getTag();
                if (var8.contains("SkullOwner", 10)) {
                    var7 = GameProfileSerializer.readGameProfile(var8.getCompound("SkullOwner"));
                } else if (var8.contains("SkullOwner", 8) && !SystemUtils.isBlank(var8.getString("SkullOwner"))) {
                    var7 = new GameProfile(SystemUtils.NIL_UUID, var8.getString("SkullOwner"));
                }
            }
            var6.setOwner(var7);
        }
    }
}

