/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockReed
extends Block {
    public static final MapCodec<BlockReed> CODEC = BlockReed.simpleCodec(BlockReed::new);
    public static final BlockStateInteger AGE = BlockProperties.AGE_15;
    protected static final float AABB_OFFSET = 6.0f;
    protected static final VoxelShape SHAPE = Block.box(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public MapCodec<BlockReed> codec() {
        return CODEC;
    }

    protected BlockReed(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (var1.isEmptyBlock(var2.above())) {
            int var4 = 1;
            while (var1.getBlockState(var2.below(var4)).is(this)) {
                ++var4;
            }
            if (var4 < 3) {
                int var5 = var0.getValue(AGE);
                if (var5 == 15) {
                    var1.setBlockAndUpdate(var2.above(), this.defaultBlockState());
                    var1.setBlock(var2, (IBlockData)var0.setValue(AGE, 0), 4);
                } else {
                    var1.setBlock(var2, (IBlockData)var0.setValue(AGE, var5 + 1), 4);
                }
            }
        }
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        IBlockData var3 = var1.getBlockState(var2.below());
        if (var3.is(this)) {
            return true;
        }
        if (var3.is(TagsBlock.DIRT) || var3.is(TagsBlock.SAND)) {
            BlockPosition var4 = var2.below();
            for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                IBlockData var7 = var1.getBlockState(var4.relative(var6));
                Fluid var8 = var1.getFluidState(var4.relative(var6));
                if (!var8.is(TagsFluid.WATER) && !var7.is(Blocks.FROSTED_ICE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE);
    }
}

