/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockRedstoneTorch;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockRedstoneTorchWall
extends BlockRedstoneTorch {
    public static final MapCodec<BlockRedstoneTorchWall> CODEC = BlockRedstoneTorchWall.simpleCodec(BlockRedstoneTorchWall::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    public static final BlockStateBoolean LIT = BlockRedstoneTorch.LIT;

    public MapCodec<BlockRedstoneTorchWall> codec() {
        return CODEC;
    }

    protected BlockRedstoneTorchWall(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(LIT, true));
    }

    @Override
    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return BlockTorchWall.getShape(var0);
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return Blocks.WALL_TORCH.canSurvive(var0, var1, var2);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        return Blocks.WALL_TORCH.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = Blocks.WALL_TORCH.getStateForPlacement(var0);
        return var1 == null ? null : (IBlockData)this.defaultBlockState().setValue(FACING, var1.getValue(FACING));
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        EnumDirection var4 = var0.getValue(FACING).getOpposite();
        double var5 = 0.27;
        double var7 = (double)var2.getX() + 0.5 + (var3.nextDouble() - 0.5) * 0.2 + 0.27 * (double)var4.getStepX();
        double var9 = (double)var2.getY() + 0.7 + (var3.nextDouble() - 0.5) * 0.2 + 0.22;
        double var11 = (double)var2.getZ() + 0.5 + (var3.nextDouble() - 0.5) * 0.2 + 0.27 * (double)var4.getStepZ();
        var1.addParticle(ParticleParamRedstone.REDSTONE, var7, var9, var11, 0.0, 0.0, 0.0);
    }

    @Override
    protected boolean hasNeighborSignal(World var0, BlockPosition var1, IBlockData var2) {
        EnumDirection var3 = var2.getValue(FACING).getOpposite();
        return var0.hasSignal(var1.relative(var3), var3);
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var0.getValue(LIT).booleanValue() && var0.getValue(FACING) != var3) {
            return 15;
        }
        return 0;
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return Blocks.WALL_TORCH.rotate(var0, var1);
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return Blocks.WALL_TORCH.mirror(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, LIT);
    }
}

