/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.animal.EntitySnowman;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;

public class BlockPumpkinCarved
extends BlockFacingHorizontal {
    public static final MapCodec<BlockPumpkinCarved> CODEC = BlockPumpkinCarved.simpleCodec(BlockPumpkinCarved::new);
    public static final BlockStateDirection FACING = BlockFacingHorizontal.FACING;
    @Nullable
    private ShapeDetector snowGolemBase;
    @Nullable
    private ShapeDetector snowGolemFull;
    @Nullable
    private ShapeDetector ironGolemBase;
    @Nullable
    private ShapeDetector ironGolemFull;
    private static final Predicate<IBlockData> PUMPKINS_PREDICATE = var0 -> var0 != null && (var0.is(Blocks.CARVED_PUMPKIN) || var0.is(Blocks.JACK_O_LANTERN));

    public MapCodec<? extends BlockPumpkinCarved> codec() {
        return CODEC;
    }

    protected BlockPumpkinCarved(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    public void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var3.is(var0.getBlock())) {
            return;
        }
        this.trySpawnGolem(var1, var2);
    }

    public boolean canSpawnGolem(IWorldReader var0, BlockPosition var1) {
        return this.getOrCreateSnowGolemBase().find(var0, var1) != null || this.getOrCreateIronGolemBase().find(var0, var1) != null;
    }

    private void trySpawnGolem(World var0, BlockPosition var1) {
        ShapeDetector.ShapeDetectorCollection var2 = this.getOrCreateSnowGolemFull().find(var0, var1);
        if (var2 != null) {
            EntitySnowman var3 = EntityTypes.SNOW_GOLEM.create(var0);
            if (var3 != null) {
                BlockPumpkinCarved.spawnGolemInWorld(var0, var2, var3, var2.getBlock(0, 2, 0).getPos());
            }
        } else {
            EntityIronGolem var4;
            ShapeDetector.ShapeDetectorCollection var3 = this.getOrCreateIronGolemFull().find(var0, var1);
            if (var3 != null && (var4 = EntityTypes.IRON_GOLEM.create(var0)) != null) {
                var4.setPlayerCreated(true);
                BlockPumpkinCarved.spawnGolemInWorld(var0, var3, var4, var3.getBlock(1, 2, 0).getPos());
            }
        }
    }

    private static void spawnGolemInWorld(World var0, ShapeDetector.ShapeDetectorCollection var1, Entity var2, BlockPosition var3) {
        BlockPumpkinCarved.clearPatternBlocks(var0, var1);
        var2.moveTo((double)var3.getX() + 0.5, (double)var3.getY() + 0.05, (double)var3.getZ() + 0.5, 0.0f, 0.0f);
        var0.addFreshEntity(var2);
        for (EntityPlayer var5 : var0.getEntitiesOfClass(EntityPlayer.class, var2.getBoundingBox().inflate(5.0))) {
            CriterionTriggers.SUMMONED_ENTITY.trigger(var5, var2);
        }
        BlockPumpkinCarved.updatePatternBlocks(var0, var1);
    }

    public static void clearPatternBlocks(World var0, ShapeDetector.ShapeDetectorCollection var1) {
        for (int var2 = 0; var2 < var1.getWidth(); ++var2) {
            for (int var3 = 0; var3 < var1.getHeight(); ++var3) {
                ShapeDetectorBlock var4 = var1.getBlock(var2, var3, 0);
                var0.setBlock(var4.getPos(), Blocks.AIR.defaultBlockState(), 2);
                var0.levelEvent(2001, var4.getPos(), Block.getId(var4.getState()));
            }
        }
    }

    public static void updatePatternBlocks(World var0, ShapeDetector.ShapeDetectorCollection var1) {
        for (int var2 = 0; var2 < var1.getWidth(); ++var2) {
            for (int var3 = 0; var3 < var1.getHeight(); ++var3) {
                ShapeDetectorBlock var4 = var1.getBlock(var2, var3, 0);
                var0.blockUpdated(var4.getPos(), Blocks.AIR);
            }
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }

    private ShapeDetector getOrCreateSnowGolemBase() {
        if (this.snowGolemBase == null) {
            this.snowGolemBase = ShapeDetectorBuilder.start().aisle(" ", "#", "#").where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemBase;
    }

    private ShapeDetector getOrCreateSnowGolemFull() {
        if (this.snowGolemFull == null) {
            this.snowGolemFull = ShapeDetectorBuilder.start().aisle("^", "#", "#").where('^', ShapeDetectorBlock.hasState(PUMPKINS_PREDICATE)).where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.SNOW_BLOCK))).build();
        }
        return this.snowGolemFull;
    }

    private ShapeDetector getOrCreateIronGolemBase() {
        if (this.ironGolemBase == null) {
            this.ironGolemBase = ShapeDetectorBuilder.start().aisle("~ ~", "###", "~#~").where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.IRON_BLOCK))).where('~', var0 -> var0.getState().isAir()).build();
        }
        return this.ironGolemBase;
    }

    private ShapeDetector getOrCreateIronGolemFull() {
        if (this.ironGolemFull == null) {
            this.ironGolemFull = ShapeDetectorBuilder.start().aisle("~^~", "###", "~#~").where('^', ShapeDetectorBlock.hasState(PUMPKINS_PREDICATE)).where('#', ShapeDetectorBlock.hasState(BlockStatePredicate.forBlock(Blocks.IRON_BLOCK))).where('~', var0 -> var0.getState().isAir()).build();
        }
        return this.ironGolemFull;
    }
}

