/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockPressurePlateAbstract;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class BlockPressurePlateBinary
extends BlockPressurePlateAbstract {
    public static final MapCodec<BlockPressurePlateBinary> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(var0 -> var0.type), BlockPressurePlateBinary.propertiesCodec()).apply((Applicative)var02, BlockPressurePlateBinary::new));
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;

    public MapCodec<BlockPressurePlateBinary> codec() {
        return CODEC;
    }

    protected BlockPressurePlateBinary(BlockSetType var0, BlockBase.Info var1) {
        super(var1, var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(POWERED, false));
    }

    @Override
    protected int getSignalForState(IBlockData var0) {
        return var0.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected IBlockData setSignalForState(IBlockData var0, int var1) {
        return (IBlockData)var0.setValue(POWERED, var1 > 0);
    }

    @Override
    protected int getSignalStrength(World var0, BlockPosition var1) {
        Class<Entity> var2 = switch (this.type.pressurePlateSensitivity()) {
            default -> throw new IncompatibleClassChangeError();
            case BlockSetType.a.EVERYTHING -> Entity.class;
            case BlockSetType.a.MOBS -> EntityLiving.class;
        };
        return BlockPressurePlateBinary.getEntityCount(var0, TOUCH_AABB.move(var1), var2) > 0 ? 15 : 0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(POWERED);
    }
}

