/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockDirtSnow;
import net.minecraft.world.level.block.BlockSnow;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.lighting.LightEngine;

public abstract class BlockDirtSnowSpreadable
extends BlockDirtSnow {
    protected BlockDirtSnowSpreadable(BlockBase.Info var0) {
        super(var0);
    }

    private static boolean canBeGrass(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.above();
        IBlockData var4 = var1.getBlockState(var3);
        if (var4.is(Blocks.SNOW) && var4.getValue(BlockSnow.LAYERS) == 1) {
            return true;
        }
        if (var4.getFluidState().getAmount() == 8) {
            return false;
        }
        int var5 = LightEngine.getLightBlockInto(var1, var0, var2, var4, var3, EnumDirection.UP, var4.getLightBlock(var1, var3));
        return var5 < var1.getMaxLightLevel();
    }

    protected abstract MapCodec<? extends BlockDirtSnowSpreadable> codec();

    private static boolean canPropagate(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.above();
        return BlockDirtSnowSpreadable.canBeGrass(var0, var1, var2) && !var1.getFluidState(var3).is(TagsFluid.WATER);
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!BlockDirtSnowSpreadable.canBeGrass(var0, var1, var2)) {
            var1.setBlockAndUpdate(var2, Blocks.DIRT.defaultBlockState());
            return;
        }
        if (var1.getMaxLocalRawBrightness(var2.above()) >= 9) {
            IBlockData var4 = this.defaultBlockState();
            for (int var5 = 0; var5 < 4; ++var5) {
                BlockPosition var6 = var2.offset(var3.nextInt(3) - 1, var3.nextInt(5) - 3, var3.nextInt(3) - 1);
                if (!var1.getBlockState(var6).is(Blocks.DIRT) || !BlockDirtSnowSpreadable.canPropagate(var4, var1, var6)) continue;
                var1.setBlockAndUpdate(var6, (IBlockData)var4.setValue(SNOWY, var1.getBlockState(var6.above()).is(Blocks.SNOW)));
            }
        }
    }
}

