/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;

public class BlockDirtSnow
extends Block {
    public static final MapCodec<BlockDirtSnow> CODEC = BlockDirtSnow.simpleCodec(BlockDirtSnow::new);
    public static final BlockStateBoolean SNOWY = BlockProperties.SNOWY;

    protected MapCodec<? extends BlockDirtSnow> codec() {
        return CODEC;
    }

    protected BlockDirtSnow(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(SNOWY, false));
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (var1 == EnumDirection.UP) {
            return (IBlockData)var0.setValue(SNOWY, BlockDirtSnow.isSnowySetting(var2));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos().above());
        return (IBlockData)this.defaultBlockState().setValue(SNOWY, BlockDirtSnow.isSnowySetting(var1));
    }

    private static boolean isSnowySetting(IBlockData var0) {
        return var0.is(TagsBlock.SNOW);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(SNOWY);
    }
}

