/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyBambooSize;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockBamboo
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<BlockBamboo> CODEC = BlockBamboo.simpleCodec(BlockBamboo::new);
    protected static final float SMALL_LEAVES_AABB_OFFSET = 3.0f;
    protected static final float LARGE_LEAVES_AABB_OFFSET = 5.0f;
    protected static final float COLLISION_AABB_OFFSET = 1.5f;
    protected static final VoxelShape SMALL_SHAPE = Block.box(5.0, 0.0, 5.0, 11.0, 16.0, 11.0);
    protected static final VoxelShape LARGE_SHAPE = Block.box(3.0, 0.0, 3.0, 13.0, 16.0, 13.0);
    protected static final VoxelShape COLLISION_SHAPE = Block.box(6.5, 0.0, 6.5, 9.5, 16.0, 9.5);
    public static final BlockStateInteger AGE = BlockProperties.AGE_1;
    public static final BlockStateEnum<BlockPropertyBambooSize> LEAVES = BlockProperties.BAMBOO_LEAVES;
    public static final BlockStateInteger STAGE = BlockProperties.STAGE;
    public static final int MAX_HEIGHT = 16;
    public static final int STAGE_GROWING = 0;
    public static final int STAGE_DONE_GROWING = 1;
    public static final int AGE_THIN_BAMBOO = 0;
    public static final int AGE_THICK_BAMBOO = 1;

    public MapCodec<BlockBamboo> codec() {
        return CODEC;
    }

    public BlockBamboo(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(AGE, 0)).setValue(LEAVES, BlockPropertyBambooSize.NONE)).setValue(STAGE, 0));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(AGE, LEAVES, STAGE);
    }

    @Override
    public boolean propagatesSkylightDown(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return true;
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        VoxelShape var4 = var0.getValue(LEAVES) == BlockPropertyBambooSize.LARGE ? LARGE_SHAPE : SMALL_SHAPE;
        Vec3D var5 = var0.getOffset(var1, var2);
        return var4.move(var5.x, var5.y, var5.z);
    }

    @Override
    public boolean isPathfindable(IBlockData var0, IBlockAccess var1, BlockPosition var2, PathMode var3) {
        return false;
    }

    @Override
    public VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        Vec3D var4 = var0.getOffset(var1, var2);
        return COLLISION_SHAPE.move(var4.x, var4.y, var4.z);
    }

    @Override
    public boolean isCollisionShapeFullBlock(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        return false;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        if (!var1.isEmpty()) {
            return null;
        }
        IBlockData var2 = var0.getLevel().getBlockState(var0.getClickedPos().below());
        if (var2.is(TagsBlock.BAMBOO_PLANTABLE_ON)) {
            if (var2.is(Blocks.BAMBOO_SAPLING)) {
                return (IBlockData)this.defaultBlockState().setValue(AGE, 0);
            }
            if (var2.is(Blocks.BAMBOO)) {
                int var3 = var2.getValue(AGE) > 0 ? 1 : 0;
                return (IBlockData)this.defaultBlockState().setValue(AGE, var3);
            }
            IBlockData var3 = var0.getLevel().getBlockState(var0.getClickedPos().above());
            if (var3.is(Blocks.BAMBOO)) {
                return (IBlockData)this.defaultBlockState().setValue(AGE, var3.getValue(AGE));
            }
            return Blocks.BAMBOO_SAPLING.defaultBlockState();
        }
        return null;
    }

    @Override
    public void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    public boolean isRandomlyTicking(IBlockData var0) {
        return var0.getValue(STAGE) == 0;
    }

    @Override
    public void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        int var4;
        if (var0.getValue(STAGE) != 0) {
            return;
        }
        if (var3.nextInt(3) == 0 && var1.isEmptyBlock(var2.above()) && var1.getRawBrightness(var2.above(), 0) >= 9 && (var4 = this.getHeightBelowUpToMax(var1, var2) + 1) < 16) {
            this.growBamboo(var0, var1, var2, var3, var4);
        }
    }

    @Override
    public boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return var1.getBlockState(var2.below()).is(TagsBlock.BAMBOO_PLANTABLE_ON);
    }

    @Override
    public IBlockData updateShape(IBlockData var0, EnumDirection var1, IBlockData var2, GeneratorAccess var3, BlockPosition var4, BlockPosition var5) {
        if (!var0.canSurvive(var3, var4)) {
            var3.scheduleTick(var4, this, 1);
        }
        if (var1 == EnumDirection.UP && var2.is(Blocks.BAMBOO) && var2.getValue(AGE) > var0.getValue(AGE)) {
            var3.setBlock(var4, (IBlockData)var0.cycle(AGE), 2);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        int var4;
        int var3 = this.getHeightAboveUpToMax(var0, var1);
        return var3 + (var4 = this.getHeightBelowUpToMax(var0, var1)) + 1 < 16 && var0.getBlockState(var1.above(var3)).getValue(STAGE) != 1;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        int var4 = this.getHeightAboveUpToMax(var0, var2);
        int var5 = this.getHeightBelowUpToMax(var0, var2);
        int var6 = var4 + var5 + 1;
        int var7 = 1 + var1.nextInt(2);
        for (int var8 = 0; var8 < var7; ++var8) {
            BlockPosition var9 = var2.above(var4);
            IBlockData var10 = var0.getBlockState(var9);
            if (var6 >= 16 || var10.getValue(STAGE) == 1 || !var0.isEmptyBlock(var9.above())) {
                return;
            }
            this.growBamboo(var10, var0, var9, var1, var6);
            ++var4;
            ++var6;
        }
    }

    @Override
    public float getDestroyProgress(IBlockData var0, EntityHuman var1, IBlockAccess var2, BlockPosition var3) {
        if (var1.getMainHandItem().getItem() instanceof ItemSword) {
            return 1.0f;
        }
        return super.getDestroyProgress(var0, var1, var2, var3);
    }

    protected void growBamboo(IBlockData var0, World var1, BlockPosition var2, RandomSource var3, int var4) {
        IBlockData var5 = var1.getBlockState(var2.below());
        BlockPosition var6 = var2.below(2);
        IBlockData var7 = var1.getBlockState(var6);
        BlockPropertyBambooSize var8 = BlockPropertyBambooSize.NONE;
        if (var4 >= 1) {
            if (!var5.is(Blocks.BAMBOO) || var5.getValue(LEAVES) == BlockPropertyBambooSize.NONE) {
                var8 = BlockPropertyBambooSize.SMALL;
            } else if (var5.is(Blocks.BAMBOO) && var5.getValue(LEAVES) != BlockPropertyBambooSize.NONE) {
                var8 = BlockPropertyBambooSize.LARGE;
                if (var7.is(Blocks.BAMBOO)) {
                    var1.setBlock(var2.below(), (IBlockData)var5.setValue(LEAVES, BlockPropertyBambooSize.SMALL), 3);
                    var1.setBlock(var6, (IBlockData)var7.setValue(LEAVES, BlockPropertyBambooSize.NONE), 3);
                }
            }
        }
        int var9 = var0.getValue(AGE) == 1 || var7.is(Blocks.BAMBOO) ? 1 : 0;
        int var10 = var4 >= 11 && var3.nextFloat() < 0.25f || var4 == 15 ? 1 : 0;
        var1.setBlock(var2.above(), (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(AGE, var9)).setValue(LEAVES, var8)).setValue(STAGE, var10), 3);
    }

    protected int getHeightAboveUpToMax(IBlockAccess var0, BlockPosition var1) {
        int var2;
        for (var2 = 0; var2 < 16 && var0.getBlockState(var1.above(var2 + 1)).is(Blocks.BAMBOO); ++var2) {
        }
        return var2;
    }

    protected int getHeightBelowUpToMax(IBlockAccess var0, BlockPosition var1) {
        int var2;
        for (var2 = 0; var2 < 16 && var0.getBlockState(var1.below(var2 + 1)).is(Blocks.BAMBOO); ++var2) {
        }
        return var2;
    }
}

