/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentProtection;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ExplosionDamageCalculatorEntity;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final int MAX_DROPS_PER_COMBINED_STACK = 16;
    private final boolean fire;
    private final Effect blockInteraction;
    private final RandomSource random = RandomSource.create();
    private final World level;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    public final Entity source;
    private final float radius;
    private final DamageSource damageSource;
    private final ExplosionDamageCalculator damageCalculator;
    private final ParticleParam smallExplosionParticles;
    private final ParticleParam largeExplosionParticles;
    private final SoundEffect explosionSound;
    private final ObjectArrayList<BlockPosition> toBlow = new ObjectArrayList();
    private final Map<EntityHuman, Vec3D> hitPlayers = Maps.newHashMap();

    public static DamageSource getDefaultDamageSource(World var0, @Nullable Entity var1) {
        return var0.damageSources().explosion(var1, Explosion.getIndirectSourceEntityInternal(var1));
    }

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8, List<BlockPosition> var9, Effect var10, ParticleParam var11, ParticleParam var12, SoundEffect var13) {
        this(var0, var1, Explosion.getDefaultDamageSource(var0, var1), null, var2, var4, var6, var8, false, var10, var11, var12, var13);
        this.toBlow.addAll(var9);
    }

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8, boolean var9, Effect var10, List<BlockPosition> var11) {
        this(var0, var1, var2, var4, var6, var8, var9, var10);
        this.toBlow.addAll(var11);
    }

    public Explosion(World var0, @Nullable Entity var1, double var2, double var4, double var6, float var8, boolean var9, Effect var10) {
        this(var0, var1, Explosion.getDefaultDamageSource(var0, var1), null, var2, var4, var6, var8, var9, var10, Particles.EXPLOSION, Particles.EXPLOSION_EMITTER, SoundEffects.GENERIC_EXPLODE);
    }

    public Explosion(World var0, @Nullable Entity var1, @Nullable DamageSource var2, @Nullable ExplosionDamageCalculator var3, double var4, double var6, double var8, float var10, boolean var11, Effect var12, ParticleParam var13, ParticleParam var14, SoundEffect var15) {
        this.level = var0;
        this.source = var1;
        this.radius = var10;
        this.x = var4;
        this.y = var6;
        this.z = var8;
        this.fire = var11;
        this.blockInteraction = var12;
        this.damageSource = var2 == null ? var0.damageSources().explosion(this) : var2;
        this.damageCalculator = var3 == null ? this.makeDamageCalculator(var1) : var3;
        this.smallExplosionParticles = var13;
        this.largeExplosionParticles = var14;
        this.explosionSound = var15;
    }

    private ExplosionDamageCalculator makeDamageCalculator(@Nullable Entity var0) {
        return var0 == null ? EXPLOSION_DAMAGE_CALCULATOR : new ExplosionDamageCalculatorEntity(var0);
    }

    public static float getSeenPercent(Vec3D var0, Entity var1) {
        AxisAlignedBB var2 = var1.getBoundingBox();
        double var3 = 1.0 / ((var2.maxX - var2.minX) * 2.0 + 1.0);
        double var5 = 1.0 / ((var2.maxY - var2.minY) * 2.0 + 1.0);
        double var7 = 1.0 / ((var2.maxZ - var2.minZ) * 2.0 + 1.0);
        double var9 = (1.0 - Math.floor(1.0 / var3) * var3) / 2.0;
        double var11 = (1.0 - Math.floor(1.0 / var7) * var7) / 2.0;
        if (var3 < 0.0 || var5 < 0.0 || var7 < 0.0) {
            return 0.0f;
        }
        int var13 = 0;
        int var14 = 0;
        for (double var15 = 0.0; var15 <= 1.0; var15 += var3) {
            for (double var17 = 0.0; var17 <= 1.0; var17 += var5) {
                for (double var19 = 0.0; var19 <= 1.0; var19 += var7) {
                    double var21 = MathHelper.lerp(var15, var2.minX, var2.maxX);
                    double var23 = MathHelper.lerp(var17, var2.minY, var2.maxY);
                    double var25 = MathHelper.lerp(var19, var2.minZ, var2.maxZ);
                    Vec3D var27 = new Vec3D(var21 + var9, var23, var25 + var11);
                    if (var1.level().clip(new RayTrace(var27, var0, RayTrace.BlockCollisionOption.COLLIDER, RayTrace.FluidCollisionOption.NONE, var1)).getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
                        ++var13;
                    }
                    ++var14;
                }
            }
        }
        return (float)var13 / (float)var14;
    }

    public float radius() {
        return this.radius;
    }

    public Vec3D center() {
        return new Vec3D(this.x, this.y, this.z);
    }

    public void explode() {
        int var4;
        int var3;
        this.level.gameEvent(this.source, GameEvent.EXPLODE, new Vec3D(this.x, this.y, this.z));
        HashSet var0 = Sets.newHashSet();
        int var1 = 16;
        for (int var2 = 0; var2 < 16; ++var2) {
            for (var3 = 0; var3 < 16; ++var3) {
                block2: for (var4 = 0; var4 < 16; ++var4) {
                    if (var2 != 0 && var2 != 15 && var3 != 0 && var3 != 15 && var4 != 0 && var4 != 15) continue;
                    double var5 = (float)var2 / 15.0f * 2.0f - 1.0f;
                    double var7 = (float)var3 / 15.0f * 2.0f - 1.0f;
                    double var9 = (float)var4 / 15.0f * 2.0f - 1.0f;
                    double var11 = Math.sqrt(var5 * var5 + var7 * var7 + var9 * var9);
                    var5 /= var11;
                    var7 /= var11;
                    var9 /= var11;
                    double var14 = this.x;
                    double var16 = this.y;
                    double var18 = this.z;
                    float var20 = 0.3f;
                    for (float var13 = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); var13 > 0.0f; var13 -= 0.22500001f) {
                        BlockPosition var21 = BlockPosition.containing(var14, var16, var18);
                        IBlockData var22 = this.level.getBlockState(var21);
                        Fluid var23 = this.level.getFluidState(var21);
                        if (!this.level.isInWorldBounds(var21)) continue block2;
                        Optional<Float> var24 = this.damageCalculator.getBlockExplosionResistance(this, this.level, var21, var22, var23);
                        if (var24.isPresent()) {
                            var13 -= (var24.get().floatValue() + 0.3f) * 0.3f;
                        }
                        if (var13 > 0.0f && this.damageCalculator.shouldBlockExplode(this, this.level, var21, var22, var13)) {
                            var0.add(var21);
                        }
                        var14 += var5 * (double)0.3f;
                        var16 += var7 * (double)0.3f;
                        var18 += var9 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)var0);
        float var2 = this.radius * 2.0f;
        var3 = MathHelper.floor(this.x - (double)var2 - 1.0);
        var4 = MathHelper.floor(this.x + (double)var2 + 1.0);
        int var5 = MathHelper.floor(this.y - (double)var2 - 1.0);
        int var6 = MathHelper.floor(this.y + (double)var2 + 1.0);
        int var7 = MathHelper.floor(this.z - (double)var2 - 1.0);
        int var8 = MathHelper.floor(this.z + (double)var2 + 1.0);
        List<Entity> var9 = this.level.getEntities(this.source, new AxisAlignedBB(var3, var5, var7, var4, var6, var8));
        Vec3D var10 = new Vec3D(this.x, this.y, this.z);
        for (Entity var12 : var9) {
            EntityHuman var28;
            double var25;
            Object var27;
            double var19;
            double var17;
            double var15;
            double var21;
            double var13;
            if (var12.ignoreExplosion(this) || !((var13 = Math.sqrt(var12.distanceToSqr(var10)) / (double)var2) <= 1.0) || (var21 = Math.sqrt((var15 = var12.getX() - this.x) * var15 + (var17 = (var12 instanceof EntityTNTPrimed ? var12.getY() : var12.getEyeY()) - this.y) * var17 + (var19 = var12.getZ() - this.z) * var19)) == 0.0) continue;
            var15 /= var21;
            var17 /= var21;
            var19 /= var21;
            if (this.damageCalculator.shouldDamageEntity(this, var12)) {
                var12.hurt(this.damageSource, this.damageCalculator.getEntityDamageAmount(this, var12));
            }
            double var23 = (1.0 - var13) * (double)Explosion.getSeenPercent(var10, var12);
            if (var12 instanceof EntityLiving) {
                var27 = (EntityLiving)var12;
                var25 = EnchantmentProtection.getExplosionKnockbackAfterDampener((EntityLiving)var27, var23);
            } else {
                var25 = var23;
            }
            var27 = new Vec3D(var15 *= var25, var17 *= var25, var19 *= var25);
            var12.setDeltaMovement(var12.getDeltaMovement().add((Vec3D)var27));
            if (!(var12 instanceof EntityHuman) || (var28 = (EntityHuman)var12).isSpectator() || var28.isCreative() && var28.getAbilities().flying) continue;
            this.hitPlayers.put(var28, (Vec3D)var27);
        }
    }

    public void finalizeExplosion(boolean var0) {
        Object var2;
        if (this.level.isClientSide) {
            this.level.playLocalSound(this.x, this.y, this.z, this.explosionSound, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
        }
        boolean var1 = this.interactsWithBlocks();
        if (var0) {
            var2 = this.radius < 2.0f || !var1 ? this.smallExplosionParticles : this.largeExplosionParticles;
            this.level.addParticle((ParticleParam)var2, this.x, this.y, this.z, 1.0, 0.0, 0.0);
        }
        if (var1) {
            this.level.getProfiler().push("explosion_blocks");
            var2 = new ArrayList();
            SystemUtils.shuffle(this.toBlow, this.level.random);
            for (BlockPosition var4 : this.toBlow) {
                this.level.getBlockState(var4).onExplosionHit(this.level, var4, this, (arg_0, arg_1) -> Explosion.b((List)var2, arg_0, arg_1));
            }
            Iterator iterator = var2.iterator();
            while (iterator.hasNext()) {
                BlockPosition var4;
                var4 = (Pair)iterator.next();
                Block.popResource(this.level, (BlockPosition)var4.getSecond(), (ItemStack)var4.getFirst());
            }
            this.level.getProfiler().pop();
        }
        if (this.fire) {
            for (BlockPosition var3 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.getBlockState(var3).isAir() || !this.level.getBlockState(var3.below()).isSolidRender(this.level, var3.below())) continue;
                this.level.setBlockAndUpdate(var3, BlockFireAbstract.getState(this.level, var3));
            }
        }
    }

    private static void addOrAppendStack(List<Pair<ItemStack, BlockPosition>> var0, ItemStack var1, BlockPosition var2) {
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            Pair<ItemStack, BlockPosition> var4 = var0.get(var3);
            ItemStack var5 = (ItemStack)var4.getFirst();
            if (!EntityItem.areMergable(var5, var1)) continue;
            var0.set(var3, (Pair<ItemStack, BlockPosition>)Pair.of((Object)EntityItem.merge(var5, var1, 16), (Object)((BlockPosition)var4.getSecond())));
            if (!var1.isEmpty()) continue;
            return;
        }
        var0.add((Pair<ItemStack, BlockPosition>)Pair.of((Object)var1, (Object)var2));
    }

    public boolean interactsWithBlocks() {
        return this.blockInteraction != Effect.KEEP;
    }

    public Map<EntityHuman, Vec3D> getHitPlayers() {
        return this.hitPlayers;
    }

    @Nullable
    private static EntityLiving getIndirectSourceEntityInternal(@Nullable Entity var0) {
        IProjectile var1;
        Entity var2;
        if (var0 == null) {
            return null;
        }
        if (var0 instanceof EntityTNTPrimed) {
            EntityTNTPrimed var12 = (EntityTNTPrimed)var0;
            return var12.getOwner();
        }
        if (var0 instanceof EntityLiving) {
            EntityLiving var13 = (EntityLiving)var0;
            return var13;
        }
        if (var0 instanceof IProjectile && (var2 = (var1 = (IProjectile)var0).getOwner()) instanceof EntityLiving) {
            EntityLiving var3 = (EntityLiving)var2;
            return var3;
        }
        return null;
    }

    @Nullable
    public EntityLiving getIndirectSourceEntity() {
        return Explosion.getIndirectSourceEntityInternal(this.source);
    }

    @Nullable
    public Entity getDirectSourceEntity() {
        return this.source;
    }

    public void clearToBlow() {
        this.toBlow.clear();
    }

    public List<BlockPosition> getToBlow() {
        return this.toBlow;
    }

    public Effect getBlockInteraction() {
        return this.blockInteraction;
    }

    public ParticleParam getSmallExplosionParticles() {
        return this.smallExplosionParticles;
    }

    public ParticleParam getLargeExplosionParticles() {
        return this.largeExplosionParticles;
    }

    public SoundEffect getExplosionSound() {
        return this.explosionSound;
    }

    private static /* synthetic */ void b(List var0, ItemStack var1, BlockPosition var2) {
        Explosion.addOrAppendStack(var0, var1, var2);
    }

    public static final class Effect
    extends Enum<Effect> {
        public static final /* enum */ Effect KEEP = new Effect();
        public static final /* enum */ Effect DESTROY = new Effect();
        public static final /* enum */ Effect DESTROY_WITH_DECAY = new Effect();
        public static final /* enum */ Effect TRIGGER_BLOCK = new Effect();
        private static final /* synthetic */ Effect[] e;

        public static Effect[] values() {
            return (Effect[])e.clone();
        }

        public static Effect valueOf(String var0) {
            return Enum.valueOf(Effect.class, var0);
        }

        private static /* synthetic */ Effect[] a() {
            return new Effect[]{KEEP, DESTROY, DESTROY_WITH_DECAY, TRIGGER_BLOCK};
        }

        static {
            e = Effect.a();
        }
    }
}

