/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.NonNullList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.Recipes;

public abstract class RecipeSingleItem
implements IRecipe<IInventory> {
    protected final RecipeItemStack ingredient;
    protected final ItemStack result;
    private final Recipes<?> type;
    private final RecipeSerializer<?> serializer;
    protected final String group;

    public RecipeSingleItem(Recipes<?> var0, RecipeSerializer<?> var1, String var2, RecipeItemStack var3, ItemStack var4) {
        this.type = var0;
        this.serializer = var1;
        this.group = var2;
        this.ingredient = var3;
        this.result = var4;
    }

    @Override
    public Recipes<?> getType() {
        return this.type;
    }

    @Override
    public RecipeSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public ItemStack getResultItem(IRegistryCustom var0) {
        return this.result;
    }

    @Override
    public NonNullList<RecipeItemStack> getIngredients() {
        NonNullList<RecipeItemStack> var0 = NonNullList.create();
        var0.add(this.ingredient);
        return var0;
    }

    @Override
    public boolean canCraftInDimensions(int var0, int var1) {
        return true;
    }

    @Override
    public ItemStack assemble(IInventory var0, IRegistryCustom var1) {
        return this.result.copy();
    }

    public static interface a<T extends RecipeSingleItem> {
        public T create(String var1, RecipeItemStack var2, ItemStack var3);
    }

    public static class b<T extends RecipeSingleItem>
    implements RecipeSerializer<T> {
        final a<T> factory;
        private final Codec<T> codec;

        protected b(a<T> var0) {
            this.factory = var0;
            this.codec = RecordCodecBuilder.create(var1 -> var1.group((App)ExtraCodecs.strictOptionalField(Codec.STRING, "group", "").forGetter(var0 -> var0.group), (App)RecipeItemStack.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(var0 -> var0.ingredient), (App)ItemStack.RESULT_CODEC.forGetter(var0 -> var0.result)).apply((Applicative)var1, var0::create));
        }

        @Override
        public Codec<T> codec() {
            return this.codec;
        }

        @Override
        public T fromNetwork(PacketDataSerializer var0) {
            String var1 = var0.readUtf();
            RecipeItemStack var2 = RecipeItemStack.fromNetwork(var0);
            ItemStack var3 = var0.readItem();
            return this.factory.create(var1, var2, var3);
        }

        @Override
        public void toNetwork(PacketDataSerializer var0, T var1) {
            var0.writeUtf(((RecipeSingleItem)var1).group);
            ((RecipeSingleItem)var1).ingredient.toNetwork(var0);
            var0.writeItem(((RecipeSingleItem)var1).result);
        }

        @Override
        public /* synthetic */ IRecipe fromNetwork(PacketDataSerializer packetDataSerializer) {
            return this.fromNetwork(packetDataSerializer);
        }
    }
}

