/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;

public class RecipeCache {
    private final a[] entries;
    private WeakReference<CraftingManager> cachedRecipeManager = new WeakReference<Object>(null);

    public RecipeCache(int var0) {
        this.entries = new a[var0];
    }

    public Optional<RecipeCrafting> get(World var0, InventoryCrafting var1) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        this.validateRecipeManager(var0);
        for (int var2 = 0; var2 < this.entries.length; ++var2) {
            a var3 = this.entries[var2];
            if (var3 == null || !var3.matches(var1.getItems())) continue;
            this.moveEntryToFront(var2);
            return Optional.ofNullable(var3.value());
        }
        return this.compute(var1, var0);
    }

    private void validateRecipeManager(World var0) {
        CraftingManager var1 = var0.getRecipeManager();
        if (var1 != this.cachedRecipeManager.get()) {
            this.cachedRecipeManager = new WeakReference<CraftingManager>(var1);
            Arrays.fill(this.entries, null);
        }
    }

    private Optional<RecipeCrafting> compute(InventoryCrafting var0, World var1) {
        Optional<RecipeHolder<RecipeCrafting>> var2 = var1.getRecipeManager().getRecipeFor(Recipes.CRAFTING, var0, var1);
        this.insert(var0.getItems(), var2.map(RecipeHolder::value).orElse(null));
        return var2.map(RecipeHolder::value);
    }

    private void moveEntryToFront(int var0) {
        if (var0 > 0) {
            a var1 = this.entries[var0];
            System.arraycopy(this.entries, 0, this.entries, 1, var0);
            this.entries[0] = var1;
        }
    }

    private void insert(List<ItemStack> var0, @Nullable RecipeCrafting var1) {
        NonNullList<ItemStack> var2 = NonNullList.withSize(var0.size(), ItemStack.EMPTY);
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            var2.set(var3, var0.get(var3).copyWithCount(1));
        }
        System.arraycopy(this.entries, 0, this.entries, 1, this.entries.length - 1);
        this.entries[0] = new a(var2, var1);
    }

    record a(NonNullList<ItemStack> key, @Nullable RecipeCrafting value) {
        public boolean matches(List<ItemStack> var0) {
            if (this.key.size() != var0.size()) {
                return false;
            }
            for (int var1 = 0; var1 < this.key.size(); ++var1) {
                if (ItemStack.isSameItemSameTags(this.key.get(var1), var0.get(var1))) continue;
                return false;
            }
            return true;
        }
    }
}

