/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;

public class ItemPotion
extends Item {
    private static final int DRINK_DURATION = 32;

    public ItemPotion(Item.Info var0) {
        super(var0);
    }

    @Override
    public ItemStack getDefaultInstance() {
        return PotionUtil.setPotion(super.getDefaultInstance(), Potions.WATER);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack var0, World var1, EntityLiving var2) {
        EntityHuman var3;
        EntityHuman entityHuman = var3 = var2 instanceof EntityHuman ? (EntityHuman)var2 : null;
        if (var3 instanceof EntityPlayer) {
            CriterionTriggers.CONSUME_ITEM.trigger((EntityPlayer)var3, var0);
        }
        if (!var1.isClientSide) {
            List<MobEffect> var4 = PotionUtil.getMobEffects(var0);
            for (MobEffect var6 : var4) {
                if (var6.getEffect().isInstantenous()) {
                    var6.getEffect().applyInstantenousEffect(var3, var3, var2, var6.getAmplifier(), 1.0);
                    continue;
                }
                var2.addEffect(new MobEffect(var6));
            }
        }
        if (var3 != null) {
            var3.awardStat(StatisticList.ITEM_USED.get(this));
            if (!var3.getAbilities().instabuild) {
                var0.shrink(1);
            }
        }
        if (var3 == null || !var3.getAbilities().instabuild) {
            if (var0.isEmpty()) {
                return new ItemStack(Items.GLASS_BOTTLE);
            }
            if (var3 != null) {
                var3.getInventory().add(new ItemStack(Items.GLASS_BOTTLE));
            }
        }
        var2.gameEvent(GameEvent.DRINK);
        return var0;
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        World var1 = var0.getLevel();
        BlockPosition var2 = var0.getClickedPos();
        EntityHuman var3 = var0.getPlayer();
        ItemStack var4 = var0.getItemInHand();
        IBlockData var5 = var1.getBlockState(var2);
        if (var0.getClickedFace() != EnumDirection.DOWN && var5.is(TagsBlock.CONVERTABLE_TO_MUD) && PotionUtil.getPotion(var4) == Potions.WATER) {
            var1.playSound(null, var2, SoundEffects.GENERIC_SPLASH, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var3.setItemInHand(var0.getHand(), ItemLiquidUtil.createFilledResult(var4, var3, new ItemStack(Items.GLASS_BOTTLE)));
            var3.awardStat(StatisticList.ITEM_USED.get(var4.getItem()));
            if (!var1.isClientSide) {
                WorldServer var6 = (WorldServer)var1;
                for (int var7 = 0; var7 < 5; ++var7) {
                    var6.sendParticles(Particles.SPLASH, (double)var2.getX() + var1.random.nextDouble(), var2.getY() + 1, (double)var2.getZ() + var1.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            var1.playSound(null, var2, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
            var1.gameEvent(null, GameEvent.FLUID_PLACE, var2);
            var1.setBlockAndUpdate(var2, Blocks.MUD.defaultBlockState());
            return EnumInteractionResult.sidedSuccess(var1.isClientSide);
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 32;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.DRINK;
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        return ItemLiquidUtil.startUsingInstantly(var0, var1, var2);
    }

    @Override
    public String getDescriptionId(ItemStack var0) {
        return PotionUtil.getPotion(var0).getName(this.getDescriptionId() + ".effect.");
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        PotionUtil.addPotionTooltip(var0, var2, 1.0f, var1 == null ? 20.0f : var1.tickRateManager().tickrate());
    }
}

