/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.MathHelper;
import net.minecraft.world.item.Item;

public class ItemCooldown {
    public final Map<Item, Info> cooldowns = Maps.newHashMap();
    public int tickCount;

    public boolean isOnCooldown(Item var0) {
        return this.getCooldownPercent(var0, 0.0f) > 0.0f;
    }

    public float getCooldownPercent(Item var0, float var1) {
        Info var2 = this.cooldowns.get(var0);
        if (var2 != null) {
            float var3 = var2.endTime - var2.startTime;
            float var4 = (float)var2.endTime - ((float)this.tickCount + var1);
            return MathHelper.clamp(var4 / var3, 0.0f, 1.0f);
        }
        return 0.0f;
    }

    public void tick() {
        ++this.tickCount;
        if (!this.cooldowns.isEmpty()) {
            Iterator<Map.Entry<Item, Info>> var0 = this.cooldowns.entrySet().iterator();
            while (var0.hasNext()) {
                Map.Entry<Item, Info> var1 = var0.next();
                if (var1.getValue().endTime > this.tickCount) continue;
                var0.remove();
                this.onCooldownEnded(var1.getKey());
            }
        }
    }

    public void addCooldown(Item var0, int var1) {
        this.cooldowns.put(var0, new Info(this.tickCount, this.tickCount + var1));
        this.onCooldownStarted(var0, var1);
    }

    public void removeCooldown(Item var0) {
        this.cooldowns.remove(var0);
        this.onCooldownEnded(var0);
    }

    protected void onCooldownStarted(Item var0, int var1) {
    }

    protected void onCooldownEnded(Item var0) {
    }

    public static class Info {
        final int startTime;
        public final int endTime;

        Info(int var0, int var1) {
            this.startTime = var0;
            this.endTime = var1;
        }
    }
}

