/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;

public interface IDyeable {
    public static final String TAG_COLOR = "color";
    public static final String TAG_DISPLAY = "display";
    public static final int DEFAULT_LEATHER_COLOR = 10511680;

    default public boolean hasCustomColor(ItemStack var0) {
        NBTTagCompound var1 = var0.getTagElement(TAG_DISPLAY);
        return var1 != null && var1.contains(TAG_COLOR, 99);
    }

    default public int getColor(ItemStack var0) {
        NBTTagCompound var1 = var0.getTagElement(TAG_DISPLAY);
        if (var1 != null && var1.contains(TAG_COLOR, 99)) {
            return var1.getInt(TAG_COLOR);
        }
        return 10511680;
    }

    default public void clearColor(ItemStack var0) {
        NBTTagCompound var1 = var0.getTagElement(TAG_DISPLAY);
        if (var1 != null && var1.contains(TAG_COLOR)) {
            var1.remove(TAG_COLOR);
        }
    }

    default public void setColor(ItemStack var0, int var1) {
        var0.getOrCreateTagElement(TAG_DISPLAY).putInt(TAG_COLOR, var1);
    }

    public static ItemStack dyeArmor(ItemStack var0, List<ItemDye> var1) {
        int var13;
        float var11;
        ItemStack var2 = ItemStack.EMPTY;
        int[] var3 = new int[3];
        int var4 = 0;
        int var5 = 0;
        IDyeable var6 = null;
        Item var7 = var0.getItem();
        if (var7 instanceof IDyeable) {
            var6 = (IDyeable)((Object)var7);
            var2 = var0.copyWithCount(1);
            if (var6.hasCustomColor(var0)) {
                int var8 = var6.getColor(var2);
                float var9 = (float)(var8 >> 16 & 0xFF) / 255.0f;
                float var10 = (float)(var8 >> 8 & 0xFF) / 255.0f;
                var11 = (float)(var8 & 0xFF) / 255.0f;
                var4 += (int)(Math.max(var9, Math.max(var10, var11)) * 255.0f);
                var3[0] = var3[0] + (int)(var9 * 255.0f);
                var3[1] = var3[1] + (int)(var10 * 255.0f);
                var3[2] = var3[2] + (int)(var11 * 255.0f);
                ++var5;
            }
            for (ItemDye var9 : var1) {
                float[] var10 = var9.getDyeColor().getTextureDiffuseColors();
                int var112 = (int)(var10[0] * 255.0f);
                int var12 = (int)(var10[1] * 255.0f);
                var13 = (int)(var10[2] * 255.0f);
                var4 += Math.max(var112, Math.max(var12, var13));
                var3[0] = var3[0] + var112;
                var3[1] = var3[1] + var12;
                var3[2] = var3[2] + var13;
                ++var5;
            }
        }
        if (var6 == null) {
            return ItemStack.EMPTY;
        }
        int var8 = var3[0] / var5;
        int var9 = var3[1] / var5;
        int var10 = var3[2] / var5;
        var11 = (float)var4 / (float)var5;
        float var12 = Math.max(var8, Math.max(var9, var10));
        var8 = (int)((float)var8 * var11 / var12);
        var9 = (int)((float)var9 * var11 / var12);
        var10 = (int)((float)var10 * var11 / var12);
        var13 = var8;
        var13 = (var13 << 8) + var9;
        var13 = (var13 << 8) + var10;
        var6.setColor(var2, var13);
        return var2;
    }
}

