/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemVanishable;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;

public interface Equipable
extends ItemVanishable {
    public EnumItemSlot getEquipmentSlot();

    default public SoundEffect getEquipSound() {
        return SoundEffects.ARMOR_EQUIP_GENERIC;
    }

    default public InteractionResultWrapper<ItemStack> swapWithEquipmentSlot(Item var0, World var1, EntityHuman var2, EnumHand var3) {
        ItemStack var4 = var2.getItemInHand(var3);
        EnumItemSlot var5 = EntityInsentient.getEquipmentSlotForItem(var4);
        ItemStack var6 = var2.getItemBySlot(var5);
        if (EnchantmentManager.hasBindingCurse(var6) && !var2.isCreative() || ItemStack.matches(var4, var6)) {
            return InteractionResultWrapper.fail(var4);
        }
        if (!var1.isClientSide()) {
            var2.awardStat(StatisticList.ITEM_USED.get(var0));
        }
        ItemStack var7 = var6.isEmpty() ? var4 : var6.copyAndClear();
        ItemStack var8 = var4.copyAndClear();
        var2.setItemSlot(var5, var8);
        return InteractionResultWrapper.sidedSuccess(var7, var1.isClientSide());
    }

    @Nullable
    public static Equipable get(ItemStack var0) {
        ItemBlock var1;
        Item item = var0.getItem();
        if (item instanceof Equipable) {
            Equipable var12 = (Equipable)((Object)item);
            return var12;
        }
        IMaterial iMaterial = var0.getItem();
        if (iMaterial instanceof ItemBlock && (iMaterial = (var1 = (ItemBlock)iMaterial).getBlock()) instanceof Equipable) {
            Equipable var2 = (Equipable)((Object)iMaterial);
            return var2;
        }
        return null;
    }
}

