/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;

public class InventoryEnderChest
extends InventorySubcontainer {
    @Nullable
    private TileEntityEnderChest activeChest;

    public InventoryEnderChest() {
        super(27);
    }

    public void setActiveChest(TileEntityEnderChest var0) {
        this.activeChest = var0;
    }

    public boolean isActiveChest(TileEntityEnderChest var0) {
        return this.activeChest == var0;
    }

    @Override
    public void fromTag(NBTTagList var0) {
        int var1;
        for (var1 = 0; var1 < this.getContainerSize(); ++var1) {
            this.setItem(var1, ItemStack.EMPTY);
        }
        for (var1 = 0; var1 < var0.size(); ++var1) {
            NBTTagCompound var2 = var0.getCompound(var1);
            int var3 = var2.getByte("Slot") & 0xFF;
            if (var3 < 0 || var3 >= this.getContainerSize()) continue;
            this.setItem(var3, ItemStack.of(var2));
        }
    }

    @Override
    public NBTTagList createTag() {
        NBTTagList var0 = new NBTTagList();
        for (int var1 = 0; var1 < this.getContainerSize(); ++var1) {
            ItemStack var2 = this.getItem(var1);
            if (var2.isEmpty()) continue;
            NBTTagCompound var3 = new NBTTagCompound();
            var3.putByte("Slot", (byte)var1);
            var2.save(var3);
            var0.add(var3);
        }
        return var0;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        if (this.activeChest != null && !this.activeChest.stillValid(var0)) {
            return false;
        }
        return super.stillValid(var0);
    }

    @Override
    public void startOpen(EntityHuman var0) {
        if (this.activeChest != null) {
            this.activeChest.startOpen(var0);
        }
        super.startOpen(var0);
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen(var0);
        }
        super.stopOpen(var0);
        this.activeChest = null;
    }
}

