/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ContainerHorse
extends Container {
    private final IInventory horseContainer;
    private final EntityHorseAbstract horse;

    public ContainerHorse(int var0, PlayerInventory var1, IInventory var2, final EntityHorseAbstract var3) {
        super(null, var0);
        int var7;
        int var6;
        this.horseContainer = var2;
        this.horse = var3;
        int var4 = 3;
        var2.startOpen(var1.player);
        int var5 = -18;
        this.addSlot(new Slot(var2, 0, 8, 18){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.is(Items.SADDLE) && !this.hasItem() && var3.isSaddleable();
            }

            @Override
            public boolean isActive() {
                return var3.isSaddleable();
            }
        });
        this.addSlot(new Slot(var2, 1, 8, 36){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var3.isArmor(var0);
            }

            @Override
            public boolean isActive() {
                return var3.canWearArmor();
            }

            @Override
            public int getMaxStackSize() {
                return 1;
            }
        });
        if (this.hasChest(var3)) {
            for (var6 = 0; var6 < 3; ++var6) {
                for (var7 = 0; var7 < ((EntityHorseChestedAbstract)var3).getInventoryColumns(); ++var7) {
                    this.addSlot(new Slot(var2, 2 + var7 + var6 * ((EntityHorseChestedAbstract)var3).getInventoryColumns(), 80 + var7 * 18, 18 + var6 * 18));
                }
            }
        }
        for (var6 = 0; var6 < 3; ++var6) {
            for (var7 = 0; var7 < 9; ++var7) {
                this.addSlot(new Slot(var1, var7 + var6 * 9 + 9, 8 + var7 * 18, 102 + var6 * 18 + -18));
            }
        }
        for (var6 = 0; var6 < 9; ++var6) {
            this.addSlot(new Slot(var1, var6, 8 + var6 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(var0) && this.horse.isAlive() && this.horse.distanceTo(var0) < 8.0f;
    }

    private boolean hasChest(EntityHorseAbstract var0) {
        return var0 instanceof EntityHorseChestedAbstract && ((EntityHorseChestedAbstract)var0).hasChest();
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            int var5 = this.horseContainer.getContainerSize();
            if (var1 < var5) {
                if (!this.moveItemStackTo(var4, var5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(var4) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(var4, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(var4)) {
                if (!this.moveItemStackTo(var4, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (var5 <= 2 || !this.moveItemStackTo(var4, 2, var5, false)) {
                int var7;
                int var6 = var5;
                int var8 = var7 = var6 + 27;
                int var9 = var8 + 9;
                if (var1 >= var8 && var1 < var9 ? !this.moveItemStackTo(var4, var6, var7, false) : (var1 >= var6 && var1 < var7 ? !this.moveItemStackTo(var4, var8, var9, false) : !this.moveItemStackTo(var4, var8, var7, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.horseContainer.stopOpen(var0);
    }
}

