/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public interface ContainerEntity
extends IInventory,
ITileInventory {
    public Vec3D position();

    @Nullable
    public MinecraftKey getLootTable();

    public void setLootTable(@Nullable MinecraftKey var1);

    public long getLootTableSeed();

    public void setLootTableSeed(long var1);

    public NonNullList<ItemStack> getItemStacks();

    public void clearItemStacks();

    public World level();

    public boolean isRemoved();

    @Override
    default public boolean isEmpty() {
        return this.isChestVehicleEmpty();
    }

    default public void addChestVehicleSaveData(NBTTagCompound var0) {
        if (this.getLootTable() != null) {
            var0.putString("LootTable", this.getLootTable().toString());
            if (this.getLootTableSeed() != 0L) {
                var0.putLong("LootTableSeed", this.getLootTableSeed());
            }
        } else {
            ContainerUtil.saveAllItems(var0, this.getItemStacks());
        }
    }

    default public void readChestVehicleSaveData(NBTTagCompound var0) {
        this.clearItemStacks();
        if (var0.contains("LootTable", 8)) {
            this.setLootTable(new MinecraftKey(var0.getString("LootTable")));
            this.setLootTableSeed(var0.getLong("LootTableSeed"));
        } else {
            ContainerUtil.loadAllItems(var0, this.getItemStacks());
        }
    }

    default public void chestVehicleDestroyed(DamageSource var0, World var1, Entity var2) {
        Entity var3;
        if (!var1.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            return;
        }
        InventoryUtils.dropContents(var1, var2, (IInventory)this);
        if (!var1.isClientSide && (var3 = var0.getDirectEntity()) != null && var3.getType() == EntityTypes.PLAYER) {
            PiglinAI.angerNearbyPiglins((EntityHuman)var3, true);
        }
    }

    default public EnumInteractionResult interactWithContainerVehicle(EntityHuman var0) {
        var0.openMenu(this);
        if (!var0.level().isClientSide) {
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.SUCCESS;
    }

    default public void unpackChestVehicleLootTable(@Nullable EntityHuman var0) {
        MinecraftServer var1 = this.level().getServer();
        if (this.getLootTable() != null && var1 != null) {
            LootTable var2 = var1.getLootData().getLootTable(this.getLootTable());
            if (var0 != null) {
                CriterionTriggers.GENERATE_LOOT.trigger((EntityPlayer)var0, this.getLootTable());
            }
            this.setLootTable(null);
            LootParams.a var3 = new LootParams.a((WorldServer)this.level()).withParameter(LootContextParameters.ORIGIN, this.position());
            if (var0 != null) {
                var3.withLuck(var0.getLuck()).withParameter(LootContextParameters.THIS_ENTITY, var0);
            }
            var2.fill(this, var3.create(LootContextParameterSets.CHEST), this.getLootTableSeed());
        }
    }

    default public void clearChestVehicleContent() {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().clear();
    }

    default public boolean isChestVehicleEmpty() {
        for (ItemStack var1 : this.getItemStacks()) {
            if (var1.isEmpty()) continue;
            return false;
        }
        return true;
    }

    default public ItemStack removeChestVehicleItemNoUpdate(int var0) {
        this.unpackChestVehicleLootTable(null);
        ItemStack var1 = this.getItemStacks().get(var0);
        if (var1.isEmpty()) {
            return ItemStack.EMPTY;
        }
        this.getItemStacks().set(var0, ItemStack.EMPTY);
        return var1;
    }

    default public ItemStack getChestVehicleItem(int var0) {
        this.unpackChestVehicleLootTable(null);
        return this.getItemStacks().get(var0);
    }

    default public ItemStack removeChestVehicleItem(int var0, int var1) {
        this.unpackChestVehicleLootTable(null);
        return ContainerUtil.removeItem(this.getItemStacks(), var0, var1);
    }

    default public void setChestVehicleItem(int var0, ItemStack var1) {
        this.unpackChestVehicleLootTable(null);
        this.getItemStacks().set(var0, var1);
        if (!var1.isEmpty() && var1.getCount() > this.getMaxStackSize()) {
            var1.setCount(this.getMaxStackSize());
        }
    }

    default public SlotAccess getChestVehicleSlot(final int var0) {
        if (var0 >= 0 && var0 < this.getContainerSize()) {
            return new SlotAccess(){

                @Override
                public ItemStack get() {
                    return ContainerEntity.this.getChestVehicleItem(var0);
                }

                @Override
                public boolean set(ItemStack var02) {
                    ContainerEntity.this.setChestVehicleItem(var0, var02);
                    return true;
                }
            };
        }
        return SlotAccess.NULL;
    }

    default public boolean isChestVehicleStillValid(EntityHuman var0) {
        return !this.isRemoved() && this.position().closerThan(var0.position(), 8.0);
    }
}

