/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class WindCharge
extends EntityFireball
implements ItemSupplier {
    public static final a EXPLOSION_DAMAGE_CALCULATOR = new a();

    public WindCharge(EntityTypes<? extends WindCharge> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
    }

    public WindCharge(EntityTypes<? extends WindCharge> var0, Breeze var1, World var2) {
        super(var0, var1.getX(), var1.getSnoutYPosition(), var1.getZ(), var2);
        this.setOwner(var1);
    }

    @Override
    protected AxisAlignedBB makeBoundingBox() {
        float var0 = this.getType().getDimensions().width / 2.0f;
        float var1 = this.getType().getDimensions().height;
        float var2 = 0.15f;
        return new AxisAlignedBB(this.position().x - (double)var0, this.position().y - (double)0.15f, this.position().z - (double)var0, this.position().x + (double)var0, this.position().y - (double)0.15f + (double)var1, this.position().z + (double)var0);
    }

    @Override
    protected float getEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.0f;
    }

    @Override
    public boolean canCollideWith(Entity var0) {
        if (var0 instanceof WindCharge) {
            return false;
        }
        return super.canCollideWith(var0);
    }

    @Override
    protected boolean canHitEntity(Entity var0) {
        if (var0 instanceof WindCharge) {
            return false;
        }
        return super.canHitEntity(var0);
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        EntityLiving var1;
        Entity entity;
        super.onHitEntity(var0);
        if (this.level().isClientSide) {
            return;
        }
        var0.getEntity().hurt(this.damageSources().mobProjectile(this, (entity = this.getOwner()) instanceof EntityLiving ? (var1 = (EntityLiving)entity) : null), 1.0f);
        this.explode();
    }

    private void explode() {
        this.level().explode(this, null, EXPLOSION_DAMAGE_CALCULATOR, this.getX(), this.getY(), this.getZ(), (float)(3.0 + this.random.nextDouble()), false, World.a.BLOW, Particles.GUST, Particles.GUST_EMITTER, SoundEffects.WIND_BURST);
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        this.explode();
        this.discard();
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public ItemStack getItem() {
        return ItemStack.EMPTY;
    }

    @Override
    protected float getInertia() {
        return 1.0f;
    }

    @Override
    protected float getLiquidInertia() {
        return this.getInertia();
    }

    @Override
    @Nullable
    protected ParticleParam getTrailParticle() {
        return null;
    }

    @Override
    protected RayTrace.BlockCollisionOption getClipType() {
        return RayTrace.BlockCollisionOption.OUTLINE;
    }

    public static final class a
    extends ExplosionDamageCalculator {
        @Override
        public boolean shouldDamageEntity(Explosion var0, Entity var1) {
            return false;
        }
    }
}

