/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;

public class EntityTippedArrow
extends EntityArrow {
    private static final int EXPOSED_POTION_DECAY_TIME = 600;
    private static final int NO_EFFECT_COLOR = -1;
    private static final DataWatcherObject<Integer> ID_EFFECT_COLOR = DataWatcher.defineId(EntityTippedArrow.class, DataWatcherRegistry.INT);
    private static final byte EVENT_POTION_PUFF = 0;
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack(Items.ARROW);
    public PotionRegistry potion = Potions.EMPTY;
    public final Set<MobEffect> effects = Sets.newHashSet();
    private boolean fixedColor;

    public EntityTippedArrow(EntityTypes<? extends EntityTippedArrow> var0, World var1) {
        super(var0, var1, DEFAULT_ARROW_STACK);
    }

    public EntityTippedArrow(World var0, double var1, double var3, double var5, ItemStack var7) {
        super(EntityTypes.ARROW, var1, var3, var5, var0, var7);
    }

    public EntityTippedArrow(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.ARROW, var1, var0, var2);
    }

    public void setEffectsFromItem(ItemStack var0) {
        if (var0.is(Items.TIPPED_ARROW)) {
            int var2;
            this.potion = PotionUtil.getPotion(var0);
            List<MobEffect> var1 = PotionUtil.getCustomEffects(var0);
            if (!var1.isEmpty()) {
                for (MobEffect var3 : var1) {
                    this.effects.add(new MobEffect(var3));
                }
            }
            if ((var2 = EntityTippedArrow.getCustomColor(var0)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(var2);
            }
        } else if (var0.is(Items.ARROW)) {
            this.potion = Potions.EMPTY;
            this.effects.clear();
            this.entityData.set(ID_EFFECT_COLOR, -1);
        }
    }

    public static int getCustomColor(ItemStack var0) {
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null && var1.contains("CustomPotionColor", 99)) {
            return var1.getInt("CustomPotionColor");
        }
        return -1;
    }

    public void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.EMPTY && this.effects.isEmpty()) {
            this.entityData.set(ID_EFFECT_COLOR, -1);
        } else {
            this.entityData.set(ID_EFFECT_COLOR, PotionUtil.getColor(PotionUtil.getAllEffects(this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffect var0) {
        this.effects.add(var0);
        this.getEntityData().set(ID_EFFECT_COLOR, PotionUtil.getColor(PotionUtil.getAllEffects(this.potion, this.effects)));
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(ID_EFFECT_COLOR, -1);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.effects.isEmpty() && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent(this, (byte)0);
            this.potion = Potions.EMPTY;
            this.effects.clear();
            this.entityData.set(ID_EFFECT_COLOR, -1);
        }
    }

    private void makeParticle(int var0) {
        int var1 = this.getColor();
        if (var1 == -1 || var0 <= 0) {
            return;
        }
        double var2 = (double)(var1 >> 16 & 0xFF) / 255.0;
        double var4 = (double)(var1 >> 8 & 0xFF) / 255.0;
        double var6 = (double)(var1 >> 0 & 0xFF) / 255.0;
        for (int var8 = 0; var8 < var0; ++var8) {
            this.level().addParticle(Particles.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), var2, var4, var6);
        }
    }

    public int getColor() {
        return this.entityData.get(ID_EFFECT_COLOR);
    }

    public void setFixedColor(int var0) {
        this.fixedColor = true;
        this.entityData.set(ID_EFFECT_COLOR, var0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        if (this.potion != Potions.EMPTY) {
            var0.putString("Potion", BuiltInRegistries.POTION.getKey(this.potion).toString());
        }
        if (this.fixedColor) {
            var0.putInt("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            NBTTagList var1 = new NBTTagList();
            for (MobEffect var3 : this.effects) {
                var1.add(var3.save(new NBTTagCompound()));
            }
            var0.put("custom_potion_effects", var1);
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("Potion", 8)) {
            this.potion = PotionUtil.getPotion(var0);
        }
        for (MobEffect var2 : PotionUtil.getCustomEffects(var0)) {
            this.addEffect(var2);
        }
        if (var0.contains("Color", 99)) {
            this.setFixedColor(var0.getInt("Color"));
        } else {
            this.updateColor();
        }
    }

    @Override
    protected void doPostHurtEffects(EntityLiving var02) {
        super.doPostHurtEffects(var02);
        Entity var1 = this.getEffectSource();
        for (MobEffect var3 : this.potion.getEffects()) {
            var02.addEffect(new MobEffect(var3.getEffect(), Math.max(var3.mapDuration(var0 -> var0 / 8), 1), var3.getAmplifier(), var3.isAmbient(), var3.isVisible()), var1);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffect var3 : this.effects) {
                var02.addEffect(var3, var1);
            }
        }
    }

    @Override
    protected ItemStack getPickupItem() {
        ItemStack var0 = super.getPickupItem();
        if (this.effects.isEmpty() && this.potion == Potions.EMPTY) {
            return var0;
        }
        PotionUtil.setPotion(var0, this.potion);
        PotionUtil.setCustomEffects(var0, this.effects);
        if (this.fixedColor) {
            var0.getOrCreateTag().putInt("CustomPotionColor", this.getColor());
        }
        return var0;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 0) {
            int var1 = this.getColor();
            if (var1 != -1) {
                double var2 = (double)(var1 >> 16 & 0xFF) / 255.0;
                double var4 = (double)(var1 >> 8 & 0xFF) / 255.0;
                double var6 = (double)(var1 >> 0 & 0xFF) / 255.0;
                for (int var8 = 0; var8 < 20; ++var8) {
                    this.level().addParticle(Particles.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), var2, var4, var6);
                }
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }
}

