/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.phys.Vec3D;

public class Slide
extends Behavior<Breeze> {
    public Slide() {
        super(Map.of(MemoryModuleType.ATTACK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_JUMP_COOLDOWN, MemoryStatus.VALUE_ABSENT, MemoryModuleType.BREEZE_SHOOT, MemoryStatus.VALUE_ABSENT));
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, Breeze var1) {
        return var1.onGround() && !var1.isInWater() && var1.getPose() == EntityPose.STANDING;
    }

    @Override
    protected void start(WorldServer var0, Breeze var1, long var2) {
        EntityLiving var4 = var1.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (var4 == null) {
            return;
        }
        boolean var5 = var1.withinOuterCircleRange(var4.position());
        boolean var6 = var1.withinMiddleCircleRange(var4.position());
        boolean var7 = var1.withinInnerCircleRange(var4.position());
        Vec3D var8 = null;
        if (var5) {
            var8 = Slide.randomPointInMiddleCircle(var1, var4);
        } else if (var7) {
            Vec3D var9 = DefaultRandomPos.getPosAway(var1, 5, 5, var4.position());
            if (var9 != null && var4.distanceToSqr(var9.x, var9.y, var9.z) > var4.distanceToSqr(var1)) {
                var8 = var9;
            }
        } else if (var6) {
            var8 = LandRandomPos.getPos(var1, 5, 3);
        }
        if (var8 != null) {
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(BlockPosition.containing(var8), 0.6f, 1));
        }
    }

    @Override
    protected void stop(WorldServer var0, Breeze var1, long var2) {
        var1.getBrain().setMemoryWithExpiry(MemoryModuleType.BREEZE_JUMP_COOLDOWN, Unit.INSTANCE, 20L);
    }

    private static Vec3D randomPointInMiddleCircle(Breeze var0, EntityLiving var1) {
        Vec3D var2 = var1.position().subtract(var0.position());
        double var3 = var2.length() - MathHelper.lerp(var0.getRandom().nextDouble(), 8.0, 4.0);
        Vec3D var5 = var2.normalize().multiply(var3, var3, var3);
        return var0.position().add(var5);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (Breeze)entityLiving, l2);
    }
}

