/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.monster.EntitySkeletonAbstract;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;

public class EntitySkeletonStray
extends EntitySkeletonAbstract {
    public EntitySkeletonStray(EntityTypes<? extends EntitySkeletonStray> var0, World var1) {
        super((EntityTypes<? extends EntitySkeletonAbstract>)var0, var1);
    }

    public static boolean checkStraySpawnRules(EntityTypes<EntitySkeletonStray> var0, WorldAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        BlockPosition var5 = var3;
        while (var1.getBlockState(var5 = var5.above()).is(Blocks.POWDER_SNOW)) {
        }
        return EntitySkeletonStray.checkMonsterSpawnRules(var0, var1, var2, var3, var4) && (EnumMobSpawn.isSpawner(var2) || var1.canSeeSky(var5.below()));
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.STRAY_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.STRAY_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.STRAY_DEATH;
    }

    @Override
    SoundEffect getStepSound() {
        return SoundEffects.STRAY_STEP;
    }

    @Override
    protected EntityArrow getArrow(ItemStack var0, float var1) {
        EntityArrow var2 = super.getArrow(var0, var1);
        if (var2 instanceof EntityTippedArrow) {
            ((EntityTippedArrow)var2).addEffect(new MobEffect(MobEffects.MOVEMENT_SLOWDOWN, 600));
        }
        return var2;
    }
}

