/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonController;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerDying
extends AbstractDragonController {
    @Nullable
    private Vec3D targetLocation;
    private int time;

    public DragonControllerDying(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doClientTick() {
        if (this.time++ % 10 == 0) {
            float var0 = (this.dragon.getRandom().nextFloat() - 0.5f) * 8.0f;
            float var1 = (this.dragon.getRandom().nextFloat() - 0.5f) * 4.0f;
            float var2 = (this.dragon.getRandom().nextFloat() - 0.5f) * 8.0f;
            this.dragon.level().addParticle(Particles.EXPLOSION_EMITTER, this.dragon.getX() + (double)var0, this.dragon.getY() + 2.0 + (double)var1, this.dragon.getZ() + (double)var2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void doServerTick() {
        double var0;
        ++this.time;
        if (this.targetLocation == null) {
            BlockPosition var02 = this.dragon.level().getHeightmapPos(HeightMap.Type.MOTION_BLOCKING, WorldGenEndTrophy.getLocation(this.dragon.getFightOrigin()));
            this.targetLocation = Vec3D.atBottomCenterOf(var02);
        }
        if ((var0 = this.targetLocation.distanceToSqr(this.dragon.getX(), this.dragon.getY(), this.dragon.getZ())) < 100.0 || var0 > 22500.0 || this.dragon.horizontalCollision || this.dragon.verticalCollision) {
            this.dragon.setHealth(0.0f);
        } else {
            this.dragon.setHealth(1.0f);
        }
    }

    @Override
    public void begin() {
        this.targetLocation = null;
        this.time = 0;
    }

    @Override
    public float getFlySpeed() {
        return 3.0f;
    }

    @Override
    @Nullable
    public Vec3D getFlyTargetLocation() {
        return this.targetLocation;
    }

    public DragonControllerPhase<DragonControllerDying> getPhase() {
        return DragonControllerPhase.DYING;
    }
}

