/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.horse;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseDonkey;
import net.minecraft.world.entity.animal.horse.EntityHorseMule;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.animal.horse.HorseStyle;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemHorseArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.SoundEffectType;

public class EntityHorse
extends EntityHorseAbstract
implements VariantHolder<HorseColor> {
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final DataWatcherObject<Integer> DATA_ID_TYPE_VARIANT = DataWatcher.defineId(EntityHorse.class, DataWatcherRegistry.INT);

    public EntityHorse(EntityTypes<? extends EntityHorse> var0, World var1) {
        super((EntityTypes<? extends EntityHorseAbstract>)var0, var1);
    }

    @Override
    protected void randomizeAttributes(RandomSource var0) {
        this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(EntityHorse.generateMaxHealth(var0::nextInt));
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(EntityHorse.generateSpeed(var0::nextDouble));
        this.getAttribute(GenericAttributes.JUMP_STRENGTH).setBaseValue(EntityHorse.generateJumpStrength(var0::nextDouble));
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_ID_TYPE_VARIANT, 0);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Variant", this.getTypeVariant());
        if (!this.inventory.getItem(1).isEmpty()) {
            var0.put("ArmorItem", this.inventory.getItem(1).save(new NBTTagCompound()));
        }
    }

    public ItemStack getArmor() {
        return this.getItemBySlot(EnumItemSlot.CHEST);
    }

    private void setArmor(ItemStack var0) {
        this.setItemSlot(EnumItemSlot.CHEST, var0);
        this.setDropChance(EnumItemSlot.CHEST, 0.0f);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        ItemStack var1;
        super.readAdditionalSaveData(var0);
        this.setTypeVariant(var0.getInt("Variant"));
        if (var0.contains("ArmorItem", 10) && !(var1 = ItemStack.of(var0.getCompound("ArmorItem"))).isEmpty() && this.isArmor(var1)) {
            this.inventory.setItem(1, var1);
        }
        this.updateContainerEquipment();
    }

    private void setTypeVariant(int var0) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, var0);
    }

    private int getTypeVariant() {
        return this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    public void setVariantAndMarkings(HorseColor var0, HorseStyle var1) {
        this.setTypeVariant(var0.getId() & 0xFF | var1.getId() << 8 & 0xFF00);
    }

    @Override
    public HorseColor getVariant() {
        return HorseColor.byId(this.getTypeVariant() & 0xFF);
    }

    @Override
    public void setVariant(HorseColor var0) {
        this.setTypeVariant(var0.getId() & 0xFF | this.getTypeVariant() & 0xFFFFFF00);
    }

    public HorseStyle getMarkings() {
        return HorseStyle.byId((this.getTypeVariant() & 0xFF00) >> 8);
    }

    @Override
    protected void updateContainerEquipment() {
        if (((World)this.level()).isClientSide) {
            return;
        }
        super.updateContainerEquipment();
        this.setArmorEquipment(this.inventory.getItem(1));
        this.setDropChance(EnumItemSlot.CHEST, 0.0f);
    }

    private void setArmorEquipment(ItemStack var0) {
        this.setArmor(var0);
        if (!((World)this.level()).isClientSide) {
            int var1;
            this.getAttribute(GenericAttributes.ARMOR).removeModifier(ARMOR_MODIFIER_UUID);
            if (this.isArmor(var0) && (var1 = ((ItemHorseArmor)var0.getItem()).getProtection()) != 0) {
                this.getAttribute(GenericAttributes.ARMOR).addTransientModifier(new AttributeModifier(ARMOR_MODIFIER_UUID, "Horse armor bonus", var1, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @Override
    public void containerChanged(IInventory var0) {
        ItemStack var1 = this.getArmor();
        super.containerChanged(var0);
        ItemStack var2 = this.getArmor();
        if (this.tickCount > 20 && this.isArmor(var2) && var1 != var2) {
            this.playSound(SoundEffects.HORSE_ARMOR, 0.5f, 1.0f);
        }
    }

    @Override
    protected void playGallopSound(SoundEffectType var0) {
        super.playGallopSound(var0);
        if (this.random.nextInt(10) == 0) {
            this.playSound(SoundEffects.HORSE_BREATHE, var0.getVolume() * 0.6f, var0.getPitch());
        }
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.HORSE_AMBIENT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.HORSE_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getEatingSound() {
        return SoundEffects.HORSE_EAT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.HORSE_HURT;
    }

    @Override
    protected SoundEffect getAngrySound() {
        return SoundEffects.HORSE_ANGRY;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        boolean var2;
        boolean bl = var2 = !this.isBaby() && this.isTamed() && var0.isSecondaryUseActive();
        if (this.isVehicle() || var2) {
            return super.mobInteract(var0, var1);
        }
        ItemStack var3 = var0.getItemInHand(var1);
        if (!var3.isEmpty()) {
            if (this.isFood(var3)) {
                return this.fedFood(var0, var3);
            }
            if (!this.isTamed()) {
                this.makeMad();
                return EnumInteractionResult.sidedSuccess(((World)this.level()).isClientSide);
            }
        }
        return super.mobInteract(var0, var1);
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 == this) {
            return false;
        }
        if (var0 instanceof EntityHorseDonkey || var0 instanceof EntityHorse) {
            return this.canParent() && ((EntityHorseAbstract)var0).canParent();
        }
        return false;
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        if (var1 instanceof EntityHorseDonkey) {
            EntityHorseMule var2 = EntityTypes.MULE.create(var0);
            if (var2 != null) {
                this.setOffspringAttributes(var1, var2);
            }
            return var2;
        }
        EntityHorse var2 = (EntityHorse)var1;
        EntityHorse var3 = EntityTypes.HORSE.create(var0);
        if (var3 != null) {
            int var5 = this.random.nextInt(9);
            HorseColor var4 = var5 < 4 ? this.getVariant() : (var5 < 8 ? var2.getVariant() : SystemUtils.getRandom(HorseColor.values(), this.random));
            int var7 = this.random.nextInt(5);
            HorseStyle var6 = var7 < 2 ? this.getMarkings() : (var7 < 4 ? var2.getMarkings() : SystemUtils.getRandom(HorseStyle.values(), this.random));
            var3.setVariantAndMarkings(var4, var6);
            this.setOffspringAttributes(var1, var3);
        }
        return var3;
    }

    @Override
    public boolean canWearArmor() {
        return true;
    }

    @Override
    public boolean isArmor(ItemStack var0) {
        return var0.getItem() instanceof ItemHorseArmor;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        HorseColor var6;
        RandomSource var5 = var0.getRandom();
        if (var3 instanceof a) {
            var6 = ((a)var3).variant;
        } else {
            var6 = SystemUtils.getRandom(HorseColor.values(), var5);
            var3 = new a(var6);
        }
        this.setVariantAndMarkings(var6, SystemUtils.getRandom(HorseStyle.values(), var5));
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static class a
    extends EntityAgeable.a {
        public final HorseColor variant;

        public a(HorseColor var0) {
            super(true);
            this.variant = var0;
        }
    }
}

