/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public interface Bucketable {
    public boolean fromBucket();

    public void setFromBucket(boolean var1);

    public void saveToBucketTag(ItemStack var1);

    public void loadFromBucketTag(NBTTagCompound var1);

    public ItemStack getBucketItemStack();

    public SoundEffect getPickupSound();

    @Deprecated
    public static void saveDefaultDataToBucketTag(EntityInsentient var0, ItemStack var1) {
        NBTTagCompound var2 = var1.getOrCreateTag();
        if (var0.hasCustomName()) {
            var1.setHoverName(var0.getCustomName());
        }
        if (var0.isNoAi()) {
            var2.putBoolean("NoAI", var0.isNoAi());
        }
        if (var0.isSilent()) {
            var2.putBoolean("Silent", var0.isSilent());
        }
        if (var0.isNoGravity()) {
            var2.putBoolean("NoGravity", var0.isNoGravity());
        }
        if (var0.hasGlowingTag()) {
            var2.putBoolean("Glowing", var0.hasGlowingTag());
        }
        if (var0.isInvulnerable()) {
            var2.putBoolean("Invulnerable", var0.isInvulnerable());
        }
        var2.putFloat("Health", var0.getHealth());
    }

    @Deprecated
    public static void loadDefaultDataFromBucketTag(EntityInsentient var0, NBTTagCompound var1) {
        if (var1.contains("NoAI")) {
            var0.setNoAi(var1.getBoolean("NoAI"));
        }
        if (var1.contains("Silent")) {
            var0.setSilent(var1.getBoolean("Silent"));
        }
        if (var1.contains("NoGravity")) {
            var0.setNoGravity(var1.getBoolean("NoGravity"));
        }
        if (var1.contains("Glowing")) {
            var0.setGlowingTag(var1.getBoolean("Glowing"));
        }
        if (var1.contains("Invulnerable")) {
            var0.setInvulnerable(var1.getBoolean("Invulnerable"));
        }
        if (var1.contains("Health", 99)) {
            var0.setHealth(var1.getFloat("Health"));
        }
    }

    public static <T extends EntityLiving> Optional<EnumInteractionResult> bucketMobPickup(EntityHuman var0, EnumHand var1, T var2) {
        ItemStack var3 = var0.getItemInHand(var1);
        if (var3.getItem() == Items.WATER_BUCKET && var2.isAlive()) {
            var2.playSound(((Bucketable)((Object)var2)).getPickupSound(), 1.0f, 1.0f);
            ItemStack var4 = ((Bucketable)((Object)var2)).getBucketItemStack();
            ((Bucketable)((Object)var2)).saveToBucketTag(var4);
            ItemStack var5 = ItemLiquidUtil.createFilledResult(var3, var0, var4, false);
            var0.setItemInHand(var1, var5);
            World var6 = var2.level();
            if (!var6.isClientSide) {
                CriterionTriggers.FILLED_BUCKET.trigger((EntityPlayer)var0, var4);
            }
            var2.discard();
            return Optional.of(EnumInteractionResult.sidedSuccess(var6.isClientSide));
        }
        return Optional.empty();
    }
}

